/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import io.jbock.jbock.auto.common.BasicAnnotationProcessor;
import io.jbock.jbock.javapoet.JavaFile;
import io.jbock.jbock.javapoet.TypeSpec;
import io.jbock.simple.Inject;
import io.jbock.util.Either;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import net.jbock.common.Annotations;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.processor.SourceElement;
import net.jbock.processor.SourceFileGenerator;
import net.jbock.validate.ValidateComponent;
import net.jbock.writing.ContextComponent;

final class CommandStep
implements BasicAnnotationProcessor.Step {
    private final Messager messager;
    private final Util util;
    private final SourceFileGenerator sourceFileGenerator;
    private final ValidateComponent.Factory validateComponentFactory;

    @Inject
    CommandStep(ProcessingEnvironment processingEnvironment, Util util, SourceFileGenerator sourceFileGenerator, ValidateComponent.Factory validateComponentFactory) {
        this.messager = processingEnvironment.getMessager();
        this.util = util;
        this.sourceFileGenerator = sourceFileGenerator;
        this.validateComponentFactory = validateComponentFactory;
    }

    @Override
    public Set<String> annotations() {
        return Annotations.typeLevelAnnotations().stream().map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        ElementFilter.typesIn(elements).forEach(element -> this.validateSourceElement((TypeElement)element).ifLeftOrElse(this::printFailures, this::processSourceElement));
        return Set.of();
    }

    private void processSourceElement(SourceElement sourceElement) {
        this.validateComponentFactory.create(sourceElement).commandProcessor().generate().map(ContextComponent::parserClass).ifLeftOrElse(this::printFailures, typeSpec -> this.writeSpec(sourceElement, (TypeSpec)typeSpec));
    }

    private void writeSpec(SourceElement sourceElement, TypeSpec typeSpec) {
        if (typeSpec.originatingElements.size() != 1) {
            throw new AssertionError();
        }
        String packageName = sourceElement.generatedClass().packageName();
        JavaFile javaFile = JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build();
        this.sourceFileGenerator.write(sourceElement, javaFile);
    }

    private Either<List<ValidationFailure>, SourceElement> validateSourceElement(TypeElement element) {
        return this.util.commonTypeChecks(element).map(List::of).map(Either::left).orElseGet(() -> Either.right((Object)SourceElement.create(element))).filter(sourceElement -> Util.checkNoDuplicateAnnotations(sourceElement.element(), Annotations.typeLevelAnnotations()).map(List::of));
    }

    private void printFailures(List<ValidationFailure> failures) {
        for (ValidationFailure failure : failures) {
            failure.writeTo(this.messager);
        }
    }
}

