/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import javax.annotation.processing.ProcessingEnvironment;
import net.jbock.common.SafeElements;
import net.jbock.common.SafeTypes;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.processor.CommandStep;
import net.jbock.processor.MethodStep;
import net.jbock.processor.ProcessorComponent;
import net.jbock.processor.SourceFileGenerator;
import net.jbock.validate.ValidateComponent;

final class ProcessorComponent_Impl
implements ProcessorComponent {
    private final CommandStep commandStep;
    private final MethodStep methodStep;

    private ProcessorComponent_Impl(CommandStep commandStep, MethodStep methodStep) {
        this.commandStep = commandStep;
        this.methodStep = methodStep;
    }

    @Override
    public MethodStep methodStep() {
        return this.methodStep;
    }

    @Override
    public CommandStep commandStep() {
        return this.commandStep;
    }

    static ProcessorComponent.Factory factory() {
        return new Factory_Impl();
    }

    private static final class Factory_Impl
    implements ProcessorComponent.Factory {
        private Factory_Impl() {
        }

        @Override
        public ProcessorComponent create(ProcessingEnvironment processingEnvironment) {
            SourceFileGenerator sourceFileGenerator = new SourceFileGenerator(processingEnvironment);
            SafeElements safeElements = new SafeElements(processingEnvironment);
            SafeTypes safeTypes = new SafeTypes(processingEnvironment);
            TypeTool typeTool = new TypeTool(safeElements, safeTypes);
            Util util = new Util(safeTypes, typeTool);
            ValidateComponent.Factory validateComponentFactory = new ValidateComponent.Factory(util, typeTool);
            CommandStep commandStep = new CommandStep(processingEnvironment, util, sourceFileGenerator, validateComponentFactory);
            MethodStep methodStep = new MethodStep(processingEnvironment, util);
            return new ProcessorComponent_Impl(commandStep, methodStep);
        }
    }
}

