/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.processor;

import io.jbock.jbock.javapoet.ClassName;
import io.jbock.jbock.javapoet.TypeName;
import io.jbock.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import net.jbock.Command;
import net.jbock.SuperCommand;
import net.jbock.common.Constants;
import net.jbock.common.SnakeName;
import net.jbock.common.Suppliers;
import net.jbock.common.ValidationFailure;

public final class SourceElement {
    private final AnyCommand command;
    private final Supplier<List<Modifier>> accessModifiers = Suppliers.memoize(() -> this.command().isPublicParser() ? List.of(Modifier.PUBLIC) : List.of());
    private final Supplier<String> programName = Suppliers.memoize(() -> Constants.optionalString(this.command().getName()).orElseGet(() -> SnakeName.create(this.command().typeElement.getSimpleName()).snake('-')));
    private final Supplier<ClassName> optionEnumType = Suppliers.memoize(() -> this.generatedClass().nestedClass("Opt"));
    private final Supplier<Optional<String>> descriptionKey = Suppliers.memoize(() -> Constants.optionalString(this.command().getDescriptionKey()));
    private final Supplier<List<String>> description = Suppliers.memoize(() -> List.of(this.command().getDescription()));
    private final Supplier<ClassName> generatedClass = Suppliers.memoize(() -> {
        ClassName commandClass = ClassName.get(this.command().typeElement);
        return commandClass.topLevelClassName().peerClass(String.join((CharSequence)"_", commandClass.simpleNames()) + "Parser");
    });

    private SourceElement(AnyCommand command) {
        this.command = command;
    }

    static SourceElement create(TypeElement t) {
        AnyCommand command = new AnyCommand(t);
        return new SourceElement(command);
    }

    public TypeElement element() {
        return this.command.typeElement;
    }

    private AnyCommand command() {
        return this.command;
    }

    public TypeName typeName() {
        return TypeName.get(this.element().asType());
    }

    public ValidationFailure fail(String message) {
        return new ValidationFailure(message, this.element());
    }

    public boolean isSuperCommand() {
        return this.command.command.isRight();
    }

    public List<Modifier> accessModifiers() {
        return this.accessModifiers.get();
    }

    public ClassName generatedClass() {
        return this.generatedClass.get();
    }

    public ClassName optionEnumType() {
        return this.optionEnumType.get();
    }

    public boolean isInterface() {
        return this.element().getKind() == ElementKind.INTERFACE;
    }

    public String programName() {
        return this.programName.get();
    }

    public Optional<String> descriptionKey() {
        return this.descriptionKey.get();
    }

    public List<String> description() {
        return this.description.get();
    }

    public boolean skipGeneratingParseOrExitMethod() {
        return this.command.isSkipGeneratingParseOrExitMethod();
    }

    public boolean parseOrExitMethodAcceptsList() {
        return this.command.isParseOrExitMethodAcceptsList();
    }

    public boolean enableAtFileExpansion() {
        return this.command.isEnableAtFileExpansion();
    }

    private static class AnyCommand {
        final Either<Command, SuperCommand> command;
        final TypeElement typeElement;

        AnyCommand(TypeElement typeElement) {
            this.typeElement = typeElement;
            Command command = typeElement.getAnnotation(Command.class);
            this.command = command != null ? Either.left((Object)command) : Either.right((Object)typeElement.getAnnotation(SuperCommand.class));
        }

        String getDescriptionKey() {
            return (String)this.command.fold(Command::descriptionKey, SuperCommand::descriptionKey);
        }

        String getName() {
            return (String)this.command.fold(Command::name, SuperCommand::name);
        }

        boolean isPublicParser() {
            return (Boolean)this.command.fold(Command::publicParser, SuperCommand::publicParser);
        }

        boolean isSkipGeneratingParseOrExitMethod() {
            return (Boolean)this.command.fold(Command::skipGeneratingParseOrExitMethod, SuperCommand::skipGeneratingParseOrExitMethod);
        }

        boolean isParseOrExitMethodAcceptsList() {
            return (Boolean)this.command.fold(Command::parseOrExitMethodAcceptsList, SuperCommand::parseOrExitMethodAcceptsList);
        }

        boolean isEnableAtFileExpansion() {
            return (Boolean)this.command.fold(Command::enableAtFileExpansion, SuperCommand::enableAtFileExpansion);
        }

        String[] getDescription() {
            return (String[])this.command.fold(Command::description, SuperCommand::description);
        }
    }
}

