/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.jbock.annotated.Items;
import net.jbock.annotated.ItemsFactory;
import net.jbock.annotated.Option;
import net.jbock.annotated.Parameter;
import net.jbock.annotated.VarargsParameter;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.processor.SourceElement;
import net.jbock.validate.OptionValidator;
import net.jbock.validate.ParameterValidator;
import net.jbock.validate.VarargsParameterValidator;
import net.jbock.writing.CommandRepresentation;

public final class CommandProcessor {
    private final ItemsFactory itemsFactory;
    private final SourceElement sourceElement;
    private final OptionValidator optionValidator;
    private final ParameterValidator parameterValidator;
    private final VarargsParameterValidator varargsParameterValidator;

    @Inject
    CommandProcessor(ItemsFactory itemsFactory, SourceElement sourceElement, OptionValidator optionValidator, ParameterValidator parameterValidator, VarargsParameterValidator varargsParameterValidator) {
        this.itemsFactory = itemsFactory;
        this.sourceElement = sourceElement;
        this.optionValidator = optionValidator;
        this.parameterValidator = parameterValidator;
        this.varargsParameterValidator = varargsParameterValidator;
    }

    public Either<List<ValidationFailure>, CommandRepresentation> generate() {
        return this.itemsFactory.createItems().filter(this::checkDuplicateDescriptionKeys).flatMap(items -> {
            Either<List<ValidationFailure>, List<Mapping<Parameter>>> a = this.parameterValidator.wrapPositionalParams((Items)items);
            Either<List<ValidationFailure>, Optional<Mapping<VarargsParameter>>> b = this.varargsParameterValidator.wrapVarargsParameters((Items)items);
            Either<List<ValidationFailure>, List<Mapping<Option>>> c = this.optionValidator.wrapOptions((Items)items);
            return a.flatMap(parameters -> b.flatMap(varargsParameter -> c.map(options -> new CommandRepresentation(this.sourceElement, (List<Mapping<Option>>)options, (List<Mapping<Parameter>>)parameters, (Optional<Mapping<VarargsParameter>>)varargsParameter))));
        });
    }

    private Optional<List<ValidationFailure>> checkDuplicateDescriptionKeys(Items items) {
        ArrayList failures = new ArrayList();
        HashSet keys = new HashSet();
        this.sourceElement.descriptionKey().ifPresent(keys::add);
        Stream.of(items.namedOptions(), items.positionalParameters(), items.varargsParameters()).flatMap(Collection::stream).forEach(m -> m.descriptionKey().ifPresent(key -> {
            if (!keys.add(key)) {
                String message = "duplicate description key: " + key;
                failures.add(m.fail(message));
            }
        }));
        return Eithers.optionalList(failures);
    }
}

