/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeKind;
import net.jbock.annotated.Items;
import net.jbock.annotated.Option;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.MappingFinder;

final class OptionValidator {
    private final MappingFinder mappingFinder;

    @Inject
    OptionValidator(MappingFinder mappingFinder) {
        this.mappingFinder = mappingFinder;
    }

    Either<List<ValidationFailure>, List<Mapping<Option>>> wrapOptions(Items items) {
        return ((Either)items.namedOptions().stream().map(this::checkOptionNames).collect(Eithers.allFailures())).filter(this::validateUniqueOptionNames).flatMap(sourceOptions -> (Either)sourceOptions.stream().map(this::wrapOption).collect(Eithers.allFailures()));
    }

    private Either<ValidationFailure, Mapping<Option>> wrapOption(Option option) {
        return this.checkNullary(option).map(this.mappingFinder::findNullaryMapping).orElseGet(() -> this.mappingFinder.findMapping(option));
    }

    private Optional<Option> checkNullary(Option option) {
        if (option.converter().isPresent()) {
            return Optional.empty();
        }
        if (option.returnType().getKind() != TypeKind.BOOLEAN) {
            return Optional.empty();
        }
        return Optional.of(option);
    }

    private Either<ValidationFailure, Option> checkOptionNames(Option option) {
        if (option.names().isEmpty()) {
            return Either.left((Object)option.fail("define at least one option name"));
        }
        return option.names().stream().map(name -> this.checkName(option, (String)name)).flatMap(Optional::stream).map(s -> s.prepend("invalid name: ")).findFirst().map(Either::left).orElseGet(() -> Either.right((Object)option));
    }

    private Optional<ValidationFailure> checkName(Option option, String name) {
        if (Objects.toString(name, "").length() <= 1 || "--".equals(name)) {
            return Optional.of(option.fail(name));
        }
        if (!name.startsWith("-")) {
            return Optional.of(option.fail("must start with a dash character: " + name));
        }
        if (name.startsWith("---")) {
            return Optional.of(option.fail("cannot start with three dashes: " + name));
        }
        if (!name.startsWith("--") && name.length() > 2) {
            return Optional.of(option.fail("single-dash name must be single-character: " + name));
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isWhitespace(c)) {
                return Optional.of(option.fail("whitespace characters: " + name));
            }
            if (c != '=') continue;
            return Optional.of(option.fail("invalid character '=': " + name));
        }
        return Optional.empty();
    }

    private Optional<List<ValidationFailure>> validateUniqueOptionNames(List<Option> allOptions) {
        HashSet allNames = new HashSet();
        return (Optional)allOptions.stream().flatMap(option -> option.names().stream().filter(name -> !allNames.add(name)).map(name -> "duplicate option name: " + name).map(option::fail)).collect(Eithers.toOptionalList());
    }
}

