/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jbock.annotated.Items;
import net.jbock.annotated.Parameter;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.MappingFinder;

final class ParameterValidator {
    private final MappingFinder mappingFinder;

    @Inject
    ParameterValidator(MappingFinder mappingFinder) {
        this.mappingFinder = mappingFinder;
    }

    Either<List<ValidationFailure>, List<Mapping<Parameter>>> wrapPositionalParams(Items items) {
        return this.validatePositions(items.positionalParameters()).flatMap(parameters -> (Either)parameters.stream().map(this.mappingFinder::findMapping).collect(Eithers.allFailures())).filter(this::checkNoRequiredAfterOptional);
    }

    private Either<List<ValidationFailure>, List<Parameter>> validatePositions(List<Parameter> parameters) {
        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            int index = parameter.index();
            if (index == i) continue;
            failures.add(parameter.fail("invalid position: expecting " + i + " but found " + index));
        }
        return Eithers.optionalList(failures).map(Either::left).orElseGet(() -> Either.right((Object)parameters));
    }

    private Optional<List<ValidationFailure>> checkNoRequiredAfterOptional(List<Mapping<Parameter>> positionalParameters) {
        return positionalParameters.stream().filter(Mapping::isOptional).findFirst().map(Mapping::item).flatMap(firstOptional -> (Optional)positionalParameters.stream().filter(Mapping::isRequired).map(Mapping::item).filter(sourceMethod -> sourceMethod.index() > firstOptional.index()).map(item -> item.fail("position of required parameter '" + item.method().getSimpleName() + "' is greater than position of optional parameter '" + firstOptional.method().getSimpleName() + "'")).collect(Eithers.toOptionalList()));
    }
}

