/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import java.util.Set;
import net.jbock.annotated.AbstractMethodsFinder;
import net.jbock.annotated.ItemsFactory;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.convert.MappingFinder;
import net.jbock.convert.map.AutoMappings;
import net.jbock.convert.map.AutoOrEnumMapper;
import net.jbock.convert.map.ConverterValidator;
import net.jbock.convert.map.MappingFactory;
import net.jbock.convert.match.MatchFinder;
import net.jbock.convert.match.Matcher;
import net.jbock.processor.SourceElement;
import net.jbock.validate.CommandProcessor;
import net.jbock.validate.OptionValidator;
import net.jbock.validate.ParameterValidator;
import net.jbock.validate.ValidateComponent;
import net.jbock.validate.VarargsParameterValidator;

public final class ValidateComponent_Impl
implements ValidateComponent {
    private final CommandProcessor commandProcessor;

    private ValidateComponent_Impl(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    @Override
    public CommandProcessor commandProcessor() {
        return this.commandProcessor;
    }

    public static Builder_Impl builder() {
        return new Builder_Impl();
    }

    public static final class Builder_Impl
    implements ValidateComponent.Builder {
        Util util;
        TypeTool tool;
        SourceElement sourceElement;

        @Override
        public Builder_Impl util(Util util) {
            this.util = util;
            return this;
        }

        @Override
        public Builder_Impl tool(TypeTool tool) {
            this.tool = tool;
            return this;
        }

        @Override
        public Builder_Impl sourceElement(SourceElement sourceElement) {
            this.sourceElement = sourceElement;
            return this;
        }

        @Override
        public ValidateComponent build() {
            Matcher matcher = Matcher.listMatcher(this.tool);
            Matcher matcher2 = Matcher.optionalMatcher(this.tool);
            Set<Matcher> validateComponentSetMatcher = ValidateComponent.allMatchers(matcher2, matcher);
            MatchFinder matchFinder = new MatchFinder(validateComponentSetMatcher, this.tool);
            MappingFactory.Factory mappingFactoryFactory = new MappingFactory.Factory(this.tool);
            ConverterValidator converterValidator = new ConverterValidator(this.tool, mappingFactoryFactory);
            AutoMappings autoMappings = new AutoMappings(this.tool);
            AutoOrEnumMapper autoOrEnumMapper = new AutoOrEnumMapper(autoMappings);
            MappingFinder mappingFinder = new MappingFinder(autoOrEnumMapper, converterValidator, this.sourceElement, this.util, matchFinder);
            VarargsParameterValidator varargsParameterValidator = new VarargsParameterValidator(mappingFinder, this.sourceElement, this.tool);
            ParameterValidator parameterValidator = new ParameterValidator(mappingFinder);
            OptionValidator optionValidator = new OptionValidator(mappingFinder);
            AbstractMethodsFinder abstractMethodsFinder = new AbstractMethodsFinder(this.sourceElement);
            ItemsFactory itemsFactory = new ItemsFactory(this.sourceElement, abstractMethodsFinder);
            CommandProcessor commandProcessor = new CommandProcessor(itemsFactory, this.sourceElement, optionValidator, parameterValidator, varargsParameterValidator);
            return new ValidateComponent_Impl(commandProcessor);
        }
    }
}

