/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.validate;

import io.jbock.simple.Inject;
import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.List;
import java.util.Optional;
import net.jbock.VarargsParameter;
import net.jbock.annotated.Items;
import net.jbock.common.TypeTool;
import net.jbock.common.ValidationFailure;
import net.jbock.convert.Mapping;
import net.jbock.convert.MappingFinder;
import net.jbock.processor.SourceElement;

final class VarargsParameterValidator {
    private final MappingFinder mappingFinder;
    private final SourceElement sourceElement;
    private final TypeTool tool;

    @Inject
    VarargsParameterValidator(MappingFinder mappingFinder, SourceElement sourceElement, TypeTool tool) {
        this.mappingFinder = mappingFinder;
        this.sourceElement = sourceElement;
        this.tool = tool;
    }

    Either<List<ValidationFailure>, Optional<Mapping<net.jbock.annotated.VarargsParameter>>> wrapVarargsParameters(Items items) {
        return this.validateDuplicateParametersAnnotation(items.varargsParameters()).filter(this::validateVarargsParameterInSuperCommand).flatMap(parameters -> (Either)parameters.stream().map(this.mappingFinder::findMapping).collect(Eithers.allFailures())).map(mappings -> mappings.stream().findAny());
    }

    private Either<List<ValidationFailure>, List<net.jbock.annotated.VarargsParameter>> validateDuplicateParametersAnnotation(List<net.jbock.annotated.VarargsParameter> parameters) {
        return ((Optional)parameters.stream().skip(1L).map(param -> param.fail("duplicate @" + VarargsParameter.class.getSimpleName() + " annotation")).collect(Eithers.toOptionalList())).map(Either::left).orElseGet(() -> Either.right((Object)parameters));
    }

    private Optional<List<ValidationFailure>> validateVarargsParameterInSuperCommand(List<net.jbock.annotated.VarargsParameter> parameters) {
        if (!this.sourceElement.isSuperCommand()) {
            return Optional.empty();
        }
        if (parameters.isEmpty()) {
            return Optional.of(List.of(this.sourceElement.fail("At least one @VarargsParameter must be defined in a @SuperCommand")));
        }
        if (!this.tool.isListOfString(parameters.get(0).returnType())) {
            return Optional.of(List.of(this.sourceElement.fail("The @VarargsParameter in a @SuperCommand must return List<String>")));
        }
        return Optional.empty();
    }
}

