/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.writing;

import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.jbock.javapoet.MethodSpec;
import io.jbock.simple.Inject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.Item;
import net.jbock.common.Suppliers;
import net.jbock.convert.Mapping;
import net.jbock.model.CommandModel;
import net.jbock.model.Multiplicity;
import net.jbock.model.Option;
import net.jbock.model.Parameter;
import net.jbock.writing.CodeBlocks;
import net.jbock.writing.CommandRepresentation;
import net.jbock.writing.HasCommandRepresentation;

final class CreateModelMethod
extends HasCommandRepresentation {
    private final Supplier<MethodSpec> define = Suppliers.memoize(() -> {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("return $T.builder()", CommandModel.class));
        this.sourceElement().descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        for (String string : this.sourceElement().description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", string));
        }
        code.add(CodeBlock.of(".withProgramName($S)", this.sourceElement().programName()));
        if (this.isSuperCommand()) {
            code.add(CodeBlock.of(".withSuperCommand($L)", true));
        }
        for (Mapping mapping : this.namedOptions()) {
            code.add(CodeBlock.of(".addOption($L)", this.optionBlock(mapping)));
        }
        Stream.concat(this.positionalParameters().stream(), this.varargsParameter().stream()).forEach(c -> code.add(CodeBlock.of(".addParameter($L)", this.parameterBlock((Mapping<?>)c))));
        code.add(CodeBlock.of(".build()", new Object[0]));
        return MethodSpec.methodBuilder("createModel").addStatement(CodeBlocks.joinByNewline(code)).returns((Type)((Object)CommandModel.class)).addModifiers(this.sourceElement().accessModifiers()).addModifiers(Modifier.STATIC).build();
    });

    @Inject
    CreateModelMethod(CommandRepresentation commandRepresentation) {
        super(commandRepresentation);
    }

    MethodSpec get() {
        return this.define.get();
    }

    private CodeBlock optionBlock(Mapping<net.jbock.annotated.Option> m) {
        ArrayList<CodeBlock> names = new ArrayList<CodeBlock>();
        for (String name : m.item().names()) {
            names.add(CodeBlock.of("$S", name));
        }
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        if (m.isNullary()) {
            code.add(CodeBlock.of("$T.nullary()", Option.class));
        } else {
            code.add(CodeBlock.of("$T.unary($T.$L)", Option.class, Multiplicity.class, m.multiplicity().name()));
        }
        code.add(CodeBlock.of(".withParamLabel($S)", m.paramLabel()));
        m.item().descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        code.add(CodeBlock.of(".withNames($T.of($L))", List.class, CodeBlocks.joinByComma(names)));
        for (String line : m.item().description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", line));
        }
        code.add(CodeBlock.of(".build()", new Object[0]));
        return CodeBlocks.joinByNewline(code);
    }

    private CodeBlock parameterBlock(Mapping<?> m) {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$T.builder($T.$L)", Parameter.class, Multiplicity.class, m.multiplicity().name()));
        code.add(CodeBlock.of(".withParamLabel($S)", m.paramLabel()));
        ((Item)m.item()).descriptionKey().ifPresent(key -> code.add(CodeBlock.of(".withDescriptionKey($S)", key)));
        for (String line : ((Item)m.item()).description()) {
            code.add(CodeBlock.of(".addDescriptionLine($S)", line));
        }
        code.add(CodeBlock.of(".build()", new Object[0]));
        return CodeBlocks.joinByNewline(code);
    }
}

