/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.writing;

import io.jbock.jbock.javapoet.ClassName;
import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.jbock.javapoet.MethodSpec;
import io.jbock.jbock.javapoet.ParameterSpec;
import io.jbock.jbock.javapoet.ParameterizedTypeName;
import io.jbock.jbock.javapoet.TypeName;
import io.jbock.jbock.javapoet.TypeSpec;
import io.jbock.simple.Inject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import net.jbock.annotated.Item;
import net.jbock.annotated.Option;
import net.jbock.annotated.Parameter;
import net.jbock.annotated.VarargsParameter;
import net.jbock.common.Constants;
import net.jbock.common.Suppliers;
import net.jbock.convert.Mapping;
import net.jbock.model.ItemType;
import net.jbock.parse.ParseResult;
import net.jbock.util.ExConvert;
import net.jbock.util.ExFailure;
import net.jbock.util.ExMissingItem;
import net.jbock.writing.CodeBlocks;
import net.jbock.writing.CommandRepresentation;
import net.jbock.writing.GeneratedTypes;
import net.jbock.writing.HasCommandRepresentation;

final class ImplClass
extends HasCommandRepresentation {
    private final GeneratedTypes generatedTypes;
    private final Supplier<ParameterSpec> resultSupplier = Suppliers.memoize(() -> {
        ParameterizedTypeName resultType = ParameterizedTypeName.get(ClassName.get(ParseResult.class), this.optType());
        return ParameterSpec.builder(resultType, "result", new Modifier[0]).build();
    });

    @Inject
    ImplClass(GeneratedTypes generatedTypes, CommandRepresentation commandRepresentation) {
        super(commandRepresentation);
        this.generatedTypes = generatedTypes;
    }

    TypeSpec define() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.generatedTypes.implType());
        if (this.sourceElement().isInterface()) {
            spec.addSuperinterface(this.sourceElement().typeName());
        } else {
            spec.superclass(this.sourceElement().typeName());
        }
        return spec.addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addMethod(this.constructor()).addMethod(this.generateToString()).addFields(this.allMappings().stream().map(Mapping::field).collect(Collectors.toList())).addMethods(this.allMappings().stream().map(this::parameterMethodOverride).collect(Collectors.toList())).build();
    }

    private MethodSpec parameterMethodOverride(Mapping<?> m) {
        Object sourceMethod = m.item();
        return MethodSpec.methodBuilder(((Item)sourceMethod).methodName()).returns(TypeName.get(((Item)sourceMethod).returnType())).addModifiers(((Item)sourceMethod).accessModifiers()).addStatement("return $N", m.field()).addAnnotation(Override.class).build();
    }

    private ParameterSpec result() {
        return this.resultSupplier.get();
    }

    private MethodSpec constructor() {
        Mapping<Item> m2;
        int i;
        MethodSpec.Builder spec = MethodSpec.constructorBuilder();
        for (i = 0; i < this.namedOptions().size(); ++i) {
            m2 = this.namedOptions().get(i);
            spec.addStatement("this.$N = $L", m2.field(), this.convertExpressionOption(m2, i));
        }
        for (i = 0; i < this.positionalParameters().size(); ++i) {
            m2 = this.positionalParameters().get(i);
            spec.addStatement("this.$N = $L", m2.field(), this.convertExpressionParameter(m2, i));
        }
        this.varargsParameter().ifPresent(m -> spec.addStatement("this.$N = $L", m.field(), this.convertExpressionVarargsParameter((Mapping<VarargsParameter>)m)));
        return spec.addParameter(this.result()).addException((Type)((Object)ExFailure.class)).build();
    }

    private MethodSpec generateToString() {
        Mapping<Item> m;
        int i;
        MethodSpec.Builder spec = MethodSpec.methodBuilder("toString").addModifiers(Modifier.PUBLIC);
        spec.addAnnotation(Override.class);
        ParameterSpec joiner = ParameterSpec.builder(StringJoiner.class, "joiner", new Modifier[0]).build();
        spec.addStatement("$T $N = new $T($S, $S, $S)", StringJoiner.class, joiner, StringJoiner.class, ", ", "{ ", " }");
        for (i = 0; i < this.namedOptions().size(); ++i) {
            m = this.namedOptions().get(i);
            spec.addStatement("$N.add($S + $N)", joiner, m.field().name + ": ", m.field());
        }
        for (i = 0; i < this.positionalParameters().size(); ++i) {
            m = this.positionalParameters().get(i);
            spec.addStatement("$N.add($S + $N)", joiner, m.field().name + ": ", m.field());
        }
        spec.addStatement("return $N.toString()", joiner);
        return spec.returns((Type)((Object)String.class)).build();
    }

    private CodeBlock convertExpressionOption(Mapping<Option> m, int i) {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.option($T.$N)", this.result(), this.sourceElement().optionEnumType(), m.enumName()));
        if (!m.isNullary()) {
            code.add(CodeBlock.of(".map($L)", m.createConverterExpression()));
        }
        code.addAll(this.tailExpressionOption(m, i));
        m.extractExpr().ifPresent(code::add);
        return CodeBlocks.joinByNewline(code);
    }

    private CodeBlock convertExpressionParameter(Mapping<Parameter> m, int i) {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.param($L)", this.result(), m.item().index()));
        code.add(CodeBlock.of(".map($L)", m.createConverterExpression()));
        code.addAll(this.tailExpressionParameter(m, i));
        m.extractExpr().ifPresent(code::add);
        return CodeBlocks.joinByNewline(code);
    }

    private CodeBlock convertExpressionVarargsParameter(Mapping<VarargsParameter> m) {
        ArrayList<CodeBlock> code = new ArrayList<CodeBlock>();
        code.add(CodeBlock.of("$N.rest()", this.result()));
        code.add(CodeBlock.of(".map($L)", m.createConverterExpression()));
        code.add(CodeBlock.of(".collect($T.firstFailure())", Constants.EITHERS));
        code.add(this.orElseThrowConverterError(ItemType.PARAMETER, this.positionalParameters().size()));
        return CodeBlocks.joinByNewline(code);
    }

    private List<CodeBlock> tailExpressionOption(Mapping<Option> m, int i) {
        if (m.isNullary()) {
            return List.of(CodeBlock.of(".findAny().isPresent()", new Object[0]));
        }
        switch (m.multiplicity()) {
            case REQUIRED: {
                return List.of(CodeBlock.of(".findAny()", new Object[0]), CodeBlock.of(".orElseThrow(() -> new $T($T.$L, $L))", ExMissingItem.class, ItemType.class, ItemType.OPTION, i), this.orElseThrowConverterError(ItemType.OPTION, i));
            }
            case OPTIONAL: {
                return List.of(CodeBlock.of(".collect($T.firstFailure())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.OPTION, i), CodeBlock.of(".stream().findAny()", new Object[0]));
            }
        }
        if (!m.isRepeatable()) {
            throw new AssertionError();
        }
        return List.of(CodeBlock.of(".collect($T.firstFailure())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.OPTION, i));
    }

    private List<CodeBlock> tailExpressionParameter(Mapping<Parameter> m, int i) {
        if (m.isRequired()) {
            return List.of(CodeBlock.of(".orElseThrow(() -> new $T($T.$L, $L))", ExMissingItem.class, ItemType.class, ItemType.PARAMETER, i), this.orElseThrowConverterError(ItemType.PARAMETER, i));
        }
        if (!m.isOptional()) {
            throw new AssertionError();
        }
        return List.of(CodeBlock.of(".stream()", new Object[0]), CodeBlock.of(".collect($T.firstFailure())", Constants.EITHERS), this.orElseThrowConverterError(ItemType.PARAMETER, i), CodeBlock.of(".stream().findAny()", new Object[0]));
    }

    private CodeBlock orElseThrowConverterError(ItemType itemType, int i) {
        ParameterSpec left = ParameterSpec.builder(Constants.STRING, "left", new Modifier[0]).build();
        return CodeBlock.of(".orElseThrow($1N -> new $2T($1N, $3T.$4L, $5L))", left, ExConvert.class, ItemType.class, itemType, i);
    }
}

