/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.writing;

import io.jbock.jbock.javapoet.ArrayTypeName;
import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.jbock.javapoet.MethodSpec;
import io.jbock.jbock.javapoet.ParameterSpec;
import io.jbock.simple.Inject;
import java.util.List;
import javax.lang.model.element.Modifier;
import net.jbock.common.Constants;
import net.jbock.contrib.StandardErrorHandler;
import net.jbock.util.AtFileError;
import net.jbock.util.ParseRequest;
import net.jbock.writing.CommandRepresentation;
import net.jbock.writing.CreateModelMethod;
import net.jbock.writing.GeneratedTypes;
import net.jbock.writing.HasCommandRepresentation;
import net.jbock.writing.ParseMethod;

final class ParseOrExitMethod
extends HasCommandRepresentation {
    private final GeneratedTypes generatedTypes;
    private final ParseMethod parseMethod;
    private final CreateModelMethod createModelMethod;

    @Inject
    ParseOrExitMethod(CommandRepresentation commandRepresentation, GeneratedTypes generatedTypes, ParseMethod parseMethod, CreateModelMethod createModelMethod) {
        super(commandRepresentation);
        this.generatedTypes = generatedTypes;
        this.parseMethod = parseMethod;
        this.createModelMethod = createModelMethod;
    }

    MethodSpec define() {
        ParameterSpec args = this.parseOrExitMethodAcceptsList() ? ParameterSpec.builder(Constants.LIST_OF_STRING, "args", new Modifier[0]).build() : ParameterSpec.builder(ArrayTypeName.of(Constants.STRING), "args", new Modifier[0]).build();
        ParameterSpec notSuccess = ParameterSpec.builder(this.generatedTypes.parseResultType(), "failure", new Modifier[0]).build();
        ParameterSpec err = ParameterSpec.builder(AtFileError.class, "err", new Modifier[0]).build();
        CodeBlock.Builder code = CodeBlock.builder();
        if (this.parseOrExitMethodAcceptsList()) {
            code.beginControlFlow("if (!$1N.isEmpty() && $2S.equals($1N.get(0)))", args, "--help");
        } else {
            code.beginControlFlow("if ($1N.length > 0 && $2S.equals($1N[0]))", args, "--help");
        }
        code.add("$T.builder().build()\n", StandardErrorHandler.class).indent().add(".printUsageDocumentation($N());\n", this.createModelMethod.get()).unindent().addStatement("$T.exit(0)", System.class).endControlFlow();
        if (this.enableAtFileExpansion()) {
            code.add("return $T.from($N).expand()\n", ParseRequest.class, args).indent().add(".mapLeft($1N -> $1N.addModel($2N()))\n", err, this.createModelMethod.get()).add(".flatMap(this::$N)\n", this.parseMethod.get()).add(".orElseThrow($N -> {\n", notSuccess).indent().addStatement("$T.builder().build().printErrorMessage($N)", StandardErrorHandler.class, notSuccess).addStatement("$T.exit(1)", System.class).addStatement("return new $T()", RuntimeException.class).unindent().addStatement("})", new Object[0]).unindent();
        } else {
            CodeBlock pArgs = this.parseOrExitMethodAcceptsList() ? CodeBlock.of("$N", args) : CodeBlock.of("$T.of($N)", List.class, args);
            code.add("return parse($L).orElseThrow($N -> {\n", pArgs, notSuccess).indent().addStatement("$T.builder().build().printErrorMessage($N)", StandardErrorHandler.class, notSuccess).addStatement("$T.exit(1)", System.class).addStatement("return new $T()", RuntimeException.class).unindent().addStatement("})", new Object[0]);
        }
        return MethodSpec.methodBuilder("parseOrExit").addParameter(args).addModifiers(this.sourceElement().accessModifiers()).returns(this.generatedTypes.sourceElement().typeName()).addModifiers(Modifier.STATIC).addCode(code.build()).build();
    }
}

