/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.writing;

import io.jbock.jbock.javapoet.MethodSpec;
import io.jbock.jbock.javapoet.TypeSpec;
import io.jbock.simple.Inject;
import javax.lang.model.element.Modifier;
import net.jbock.writing.CommandRepresentation;
import net.jbock.writing.CreateModelMethod;
import net.jbock.writing.GeneratedAnnotation;
import net.jbock.writing.HasCommandRepresentation;
import net.jbock.writing.ImplClass;
import net.jbock.writing.OptEnum;
import net.jbock.writing.OptionNamesMethod;
import net.jbock.writing.OptionStatesMethod;
import net.jbock.writing.ParseMethod;
import net.jbock.writing.ParseOrExitMethod;

final class ParserClass
extends HasCommandRepresentation {
    private final ParseMethod parseMethod;
    private final OptEnum optionEnum;
    private final ParseOrExitMethod parseOrExitMethod;
    private final CreateModelMethod createModelMethod;
    private final GeneratedAnnotation generatedAnnotation;
    private final OptionNamesMethod optionNamesMethod;
    private final OptionStatesMethod optionStatesMethod;
    private final ImplClass implClass;

    @Inject
    ParserClass(ParseMethod parseMethod, CommandRepresentation commandRepresentation, OptEnum optionEnum, ParseOrExitMethod parseOrExitMethod, CreateModelMethod createModelMethod, GeneratedAnnotation generatedAnnotation, OptionNamesMethod optionNamesMethod, OptionStatesMethod optionStatesMethod, ImplClass implClass) {
        super(commandRepresentation);
        this.parseMethod = parseMethod;
        this.optionEnum = optionEnum;
        this.parseOrExitMethod = parseOrExitMethod;
        this.createModelMethod = createModelMethod;
        this.generatedAnnotation = generatedAnnotation;
        this.optionNamesMethod = optionNamesMethod;
        this.optionStatesMethod = optionStatesMethod;
        this.implClass = implClass;
    }

    TypeSpec define() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.sourceElement().generatedClass());
        spec.addMethod(this.parseMethod.get());
        if (!this.sourceElement().skipGeneratingParseOrExitMethod()) {
            spec.addMethod(this.parseOrExitMethod.define());
        }
        if (!this.namedOptions().isEmpty()) {
            spec.addMethod(this.optionNamesMethod.get());
            spec.addMethod(this.optionStatesMethod.get());
            spec.addType(this.optionEnum.define());
        }
        spec.addMethod(this.createModelMethod.get());
        Modifier[] modifiers = this.sourceElement().accessModifiers().toArray(new Modifier[0]);
        spec.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        return spec.addOriginatingElement(this.sourceElement().element()).addModifiers(modifiers).addModifiers(Modifier.FINAL).addType(this.implClass.define()).addAnnotation(this.generatedAnnotation.define()).build();
    }
}

