/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.writing;

import io.jbock.jbock.javapoet.ClassName;
import io.jbock.jbock.javapoet.CodeBlock;
import io.jbock.jbock.javapoet.ParameterizedTypeName;
import io.jbock.simple.Inject;
import java.util.Map;
import java.util.function.Supplier;
import net.jbock.common.Suppliers;
import net.jbock.parse.StandardParser;
import net.jbock.parse.SuperParser;
import net.jbock.parse.VarargsParameterParser;
import net.jbock.writing.CommandRepresentation;
import net.jbock.writing.HasCommandRepresentation;
import net.jbock.writing.OptionNamesMethod;
import net.jbock.writing.OptionStatesMethod;
import net.jbock.writing.ParserType;

final class ParserTypeFactory
extends HasCommandRepresentation {
    private final OptionStatesMethod optionStatesMethod;
    private final OptionNamesMethod optionNamesMethod;
    private final Supplier<ParserType> parserType = Suppliers.memoize(() -> {
        CodeBlock optionNames = this.namedOptions().isEmpty() ? CodeBlock.of("$T.of()", Map.class) : CodeBlock.of("$N()", this.optionNamesMethod().get());
        CodeBlock optionStates = this.namedOptions().isEmpty() ? CodeBlock.of("$T.of()", Map.class) : CodeBlock.of("$N()", this.optionStatesMethod().get());
        int numParams = this.positionalParameters().size();
        if (this.isSuperCommand()) {
            ClassName parserClass = ClassName.get(SuperParser.class);
            CodeBlock init = CodeBlock.of("$T.create($L, $L, $L)", ClassName.get(SuperParser.class), optionNames, optionStates, numParams);
            return new ParserType(ParameterizedTypeName.get(parserClass, this.optType()), init);
        }
        if (this.varargsParameter().isPresent()) {
            ClassName parserClass = ClassName.get(VarargsParameterParser.class);
            CodeBlock init = CodeBlock.of("$T.create($L, $L, $L)", ClassName.get(VarargsParameterParser.class), optionNames, optionStates, numParams);
            return new ParserType(ParameterizedTypeName.get(parserClass, this.optType()), init);
        }
        ClassName parserClass = ClassName.get(StandardParser.class);
        CodeBlock init = CodeBlock.of("$T.create($L, $L, $L)", ClassName.get(StandardParser.class), optionNames, optionStates, numParams);
        return new ParserType(ParameterizedTypeName.get(parserClass, this.optType()), init);
    });

    @Inject
    ParserTypeFactory(CommandRepresentation commandRepresentation, OptionStatesMethod optionStatesMethod, OptionNamesMethod optionNamesMethod) {
        super(commandRepresentation);
        this.optionStatesMethod = optionStatesMethod;
        this.optionNamesMethod = optionNamesMethod;
    }

    ParserType get() {
        return this.parserType.get();
    }

    private OptionStatesMethod optionStatesMethod() {
        return this.optionStatesMethod;
    }

    private OptionNamesMethod optionNamesMethod() {
        return this.optionNamesMethod;
    }
}

