/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.jbock.model.Arity;
import net.jbock.model.Item;
import net.jbock.model.ItemType;
import net.jbock.model.Multiplicity;

public final class Option
extends Item {
    private final List<String> names;
    private final Arity arity;

    private Option(String paramLabel, String descriptionKey, List<String> description, List<String> names, Multiplicity multiplicity, Arity arity) {
        super(paramLabel, descriptionKey, description, multiplicity);
        if (names.isEmpty()) {
            throw new IllegalArgumentException("paramLabel may not be empty");
        }
        this.names = names;
        this.arity = arity;
    }

    public static Builder nullary() {
        return new Builder(Multiplicity.OPTIONAL, Arity.NULLARY);
    }

    public static Builder unary(Multiplicity multiplicity) {
        return new Builder(multiplicity, Arity.UNARY);
    }

    @Override
    public String namesOverview() {
        String sample = String.join((CharSequence)", ", this.names);
        switch (this.arity) {
            case NULLARY: {
                return sample;
            }
            case UNARY: {
                return sample + " " + this.paramLabel();
            }
        }
        throw new AssertionError((Object)"all cases exhausted");
    }

    @Override
    public String namesOverviewError() {
        return this.itemType().name().toLowerCase(Locale.US) + " " + this.paramLabel() + " (" + String.join((CharSequence)", ", this.names) + ")";
    }

    @Override
    public ItemType itemType() {
        return ItemType.OPTION;
    }

    public List<String> names() {
        return this.names;
    }

    public Arity arity() {
        return this.arity;
    }

    public static final class Builder {
        private String paramLabel;
        private String descriptionKey = "";
        private final List<String> description = new ArrayList<String>();
        private List<String> names;
        private final Multiplicity multiplicity;
        private final Arity arity;

        private Builder(Multiplicity multiplicity, Arity arity) {
            this.multiplicity = multiplicity;
            this.arity = arity;
        }

        public Builder withParamLabel(String paramLabel) {
            this.paramLabel = paramLabel;
            return this;
        }

        public Builder withDescriptionKey(String descriptionKey) {
            this.descriptionKey = descriptionKey;
            return this;
        }

        public Builder addDescriptionLine(String descriptionLine) {
            this.description.add(descriptionLine);
            return this;
        }

        public Builder withNames(List<String> names) {
            this.names = names;
            return this;
        }

        public Option build() {
            return new Option(this.paramLabel, this.descriptionKey, this.description, this.names, this.multiplicity, this.arity);
        }
    }
}

