/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.contrib;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jbock.util.StringConverter;

public final class EnumConverter<E>
extends StringConverter<E> {
    private final Function<String, E> valueOf;
    private final E[] values;

    private EnumConverter(Function<String, E> valueOf, E[] values) {
        this.valueOf = valueOf;
        this.values = values;
    }

    public static <E> StringConverter<E> create(Function<String, E> valueOf, Supplier<E[]> values) {
        return new EnumConverter<E>(valueOf, values.get());
    }

    @Override
    protected E convert(String token) {
        try {
            return this.valueOf.apply(token);
        }
        catch (IllegalArgumentException e) {
            return this.tryCaseInsensitive(token);
        }
    }

    private E tryCaseInsensitive(String token) {
        for (E value : this.values) {
            if (!Objects.toString(value, "").equalsIgnoreCase(token)) continue;
            return value;
        }
        String strings = Arrays.stream(this.values).map(Objects::toString).map(s -> s.toUpperCase(Locale.ROOT)).collect(Collectors.joining("\n  ", "", "\n"));
        String message = "No such constant: " + token.toUpperCase(Locale.ROOT) + "\nPossible values (ignoring case):\n  " + strings;
        throw new RuntimeException(message);
    }
}

