/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.contrib;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jbock.contrib.AnsiStyle;
import net.jbock.contrib.Synopsis;
import net.jbock.contrib.UsageDocumentation;
import net.jbock.model.CommandModel;
import net.jbock.util.ParsingFailed;

public final class StandardErrorHandler {
    private final PrintStream out;
    private final int terminalWidth;
    private final boolean ansi;
    private final Map<String, String> messages;

    private StandardErrorHandler(PrintStream out, int terminalWidth, boolean ansi, Map<String, String> messages) {
        this.out = out;
        this.terminalWidth = terminalWidth;
        this.ansi = ansi;
        this.messages = messages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void printUsageDocumentation(CommandModel model) {
        UsageDocumentation.builder(model).withOutputStream(this.out).withAnsi(this.ansi).withMessages(this.messages).withTerminalWidth(this.terminalWidth).build().printUsageDocumentation();
        this.out.flush();
    }

    public void printErrorMessage(ParsingFailed failure) {
        CommandModel model = failure.commandModel();
        AnsiStyle ansiStyle = AnsiStyle.create(this.ansi);
        this.out.println(ansiStyle.red("ERROR:") + " " + failure.message());
        List<String> synopsis = Synopsis.create(model).createSynopsis("Usage:");
        this.out.println(String.join((CharSequence)" ", synopsis));
        String helpCommand = model.programName() + " --help";
        this.out.println("Type " + ansiStyle.bold(helpCommand).orElseGet(() -> "'" + helpCommand + "'") + " for more information.");
        this.out.flush();
    }

    public static final class Builder {
        private PrintStream out = System.err;
        private int terminalWidth = 80;
        private boolean ansi = true;
        private Map<String, String> messages = Collections.emptyMap();

        private Builder() {
        }

        public Builder withOutputStream(PrintStream out) {
            this.out = out;
            return this;
        }

        public Builder withTerminalWidth(int width) {
            this.terminalWidth = width == 0 ? this.terminalWidth : width;
            return this;
        }

        public Builder withMessages(Map<String, String> map) {
            this.messages = map;
            return this;
        }

        public Builder withAnsi(boolean ansi) {
            this.ansi = ansi;
            return this;
        }

        public StandardErrorHandler build() {
            return new StandardErrorHandler(this.out, this.terminalWidth, this.ansi, this.messages);
        }
    }
}

