/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.parse;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.jbock.parse.OptionState;
import net.jbock.parse.ParseResult;
import net.jbock.util.ErrTokenType;
import net.jbock.util.ExToken;

abstract class AbstractParser<T>
implements ParseResult<T> {
    private static final Pattern SUSPICIOUS = Pattern.compile("-[a-zA-Z0-9]+|--[a-zA-Z0-9-]+");
    private final Map<String, T> optionNames;
    private final Map<T, OptionState> optionStates;
    private final String[] params;

    AbstractParser(Map<String, T> optionNames, Map<T, OptionState> optionStates, int numParams) {
        this.optionNames = optionNames;
        this.optionStates = optionStates;
        this.params = new String[numParams];
    }

    final void parse(Iterator<String> it) throws ExToken {
        int position = 0;
        boolean endOfOptionParsing = false;
        while (it.hasNext()) {
            String token = it.next();
            if (!(endOfOptionParsing |= this.hasOptionParsingEnded(position))) {
                if (this.isEscapeSequence(token)) {
                    endOfOptionParsing = true;
                    continue;
                }
                if (this.tryReadOption(token, it)) continue;
                if (SUSPICIOUS.matcher(token).matches()) {
                    throw new ExToken(ErrTokenType.INVALID_OPTION, token);
                }
            }
            if (position < this.params.length) {
                this.params[position++] = token;
                continue;
            }
            this.handleExcessParam(token);
        }
    }

    abstract boolean hasOptionParsingEnded(int var1);

    abstract boolean isEscapeSequence(String var1);

    abstract void handleExcessParam(String var1) throws ExToken;

    public final void parse(List<String> tokens) throws ExToken {
        this.parse(tokens.iterator());
    }

    private boolean tryReadOption(String token, Iterator<String> it) throws ExToken {
        String name = this.readOptionName(token);
        if (name == null) {
            return false;
        }
        T opt = this.optionNames.get(name);
        if (opt == null) {
            return false;
        }
        String t = token;
        while ((t = this.optionStates.get(opt).read(t, it)) != null) {
            name = this.readOptionName(t);
            if (name == null) {
                throw new ExToken(ErrTokenType.INVALID_UNIX_GROUP, token);
            }
            opt = this.optionNames.get(name);
            if (opt != null) continue;
            throw new ExToken(ErrTokenType.INVALID_UNIX_GROUP, token);
        }
        return true;
    }

    private String readOptionName(String token) {
        if (token.length() < 2 || !token.startsWith("-")) {
            return null;
        }
        if (!token.startsWith("--")) {
            return token.substring(0, 2);
        }
        if (!token.contains("=")) {
            return token;
        }
        return token.substring(0, token.indexOf(61));
    }

    @Override
    public final Stream<String> option(T option) {
        OptionState optionState = this.optionStates.get(option);
        if (optionState == null) {
            return Stream.empty();
        }
        return optionState.stream();
    }

    @Override
    public final Optional<String> param(int index) {
        if (index < 0 || index >= this.params.length) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.params[index]);
    }

    final int numParams() {
        return this.params.length;
    }
}

