/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.jbock.util.AtFileError;
import net.jbock.util.AtFileReadError;
import net.jbock.util.AtFileSyntaxError;
import net.jbock.util.ParseRequest;

final class ParseRequestExpand
extends ParseRequest {
    private final Path path;
    private final List<String> args;

    ParseRequestExpand(Path path, List<String> args) {
        this.path = path;
        this.args = args;
    }

    @Override
    public Either<? extends AtFileError, List<String>> expand() {
        try {
            List<String> lines = Files.readAllLines(this.path);
            return this.readAtLines(lines).mapLeft(r -> new AtFileSyntaxError(this.path, r.number, r.lineResult.message())).map(atLines -> {
                ArrayList<String> atLinesWithRest = new ArrayList<String>((Collection<String>)atLines);
                atLinesWithRest.addAll(this.args);
                return atLinesWithRest;
            });
        }
        catch (Exception e) {
            return Either.left((Object)new AtFileReadError(e, this.path));
        }
    }

    Either<NumberedLineResult, List<String>> readAtLines(List<String> lines) {
        int[] counter = new int[]{1};
        Iterator<NumberedLine> it = lines.stream().filter(line -> !line.isEmpty()).map(line -> {
            int n = counter[0];
            counter[0] = n + 1;
            return new NumberedLine(n, (String)line);
        }).iterator();
        ArrayList<Either<NumberedLineResult, String>> tokens = new ArrayList<Either<NumberedLineResult, String>>(lines.size());
        while (it.hasNext()) {
            tokens.add(this.readTokenFromAtFile(it));
        }
        return (Either)tokens.stream().collect(Eithers.firstFailure());
    }

    private Either<NumberedLineResult, String> readTokenFromAtFile(Iterator<NumberedLine> it) {
        NumberedLine current;
        LineResult esc;
        StringBuilder sb = new StringBuilder();
        do {
            current = it.next();
        } while ((esc = this.readLine(current.line, sb)) == LineResult.CONTINUE && it.hasNext());
        if (esc.isError()) {
            return Either.left((Object)new NumberedLineResult(current.number, esc));
        }
        if (esc == LineResult.CONTINUE && !it.hasNext()) {
            return Either.left((Object)new NumberedLineResult(current.number, LineResult.BACKSLASH_BEFORE_EOF));
        }
        return Either.right((Object)sb.toString());
    }

    private LineResult readLine(String line, StringBuilder sb) {
        boolean esc = false;
        Mode mode = Mode.PLAIN;
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            char c = line.charAt(i);
            if (c == '\'' && mode != Mode.DOUBLE_QUOTE) {
                if (esc) {
                    sb.append('\'');
                    continue;
                }
                mode = mode.toggle(Mode.SINGLE_QUOTE);
                continue;
            }
            if (mode != Mode.SINGLE_QUOTE && c == '\\') {
                if (esc) {
                    sb.append('\\');
                    esc = false;
                    continue;
                }
                esc = true;
                continue;
            }
            if (mode != Mode.SINGLE_QUOTE && !esc && c == '\"') {
                mode = mode.toggle(Mode.DOUBLE_QUOTE);
                continue;
            }
            if (esc) {
                sb.append(this.escapeValue(c));
                esc = false;
                continue;
            }
            sb.append(c);
        }
        if (mode != Mode.PLAIN) {
            return LineResult.UNMATCHED_QUOTE;
        }
        return esc ? LineResult.CONTINUE : LineResult.END;
    }

    private char escapeValue(char c) {
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return c;
    }

    private static class NumberedLine {
        final int number;
        final String line;

        NumberedLine(int number, String line) {
            this.number = number;
            this.line = line;
        }
    }

    static enum LineResult {
        CONTINUE,
        END,
        UNMATCHED_QUOTE{

            @Override
            boolean isError() {
                return true;
            }

            @Override
            String message() {
                return "unmatched quote";
            }
        }
        ,
        BACKSLASH_BEFORE_EOF{

            @Override
            boolean isError() {
                return true;
            }

            @Override
            String message() {
                return "backslash at end of file";
            }
        };


        boolean isError() {
            return false;
        }

        String message() {
            return "";
        }
    }

    static final class NumberedLineResult {
        private final int number;
        private final LineResult lineResult;

        private NumberedLineResult(int number, LineResult lineResult) {
            this.number = number;
            this.lineResult = lineResult;
        }

        int number() {
            return this.number;
        }

        LineResult lineResult() {
            return this.lineResult;
        }
    }

    private static enum Mode {
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        PLAIN;


        Mode toggle(Mode other) {
            return this == other ? PLAIN : other;
        }
    }
}

