/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.truth.AutoValue_ActualValueInference_DescribedEntry;
import com.google.common.truth.AutoValue_ActualValueInference_FrameInfo;
import com.google.common.truth.AutoValue_ActualValueInference_InferredType;
import com.google.common.truth.AutoValue_ActualValueInference_Invocation;
import com.google.common.truth.AutoValue_ActualValueInference_OpaqueEntry;
import com.google.common.truth.AutoValue_ActualValueInference_SubjectEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@GwtIncompatible
final class ActualValueInference {
    private static final ImmutableSet<String> BORING_NAMES = ImmutableSet.of((Object)"asList", (Object)"build", (Object)"collect", (Object)"copyOf", (Object)"create", (Object)"from", (Object[])new String[]{"get", "iterator", "of", "toArray", "toString", "valueOf"});
    private static final ImmutableSet<String> PRIMITIVE_WRAPPERS = ImmutableSet.of((Object)"java/lang/Boolean", (Object)"java/lang/Byte", (Object)"java/lang/Character", (Object)"java/lang/Double", (Object)"java/lang/Float", (Object)"java/lang/Integer", (Object[])new String[]{"java/lang/Long", "java/lang/Short"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static String describeActualValue(String className, String methodName, int lineNumber) {
        InferenceClassVisitor visitor;
        try {
            visitor = new InferenceClassVisitor(methodName);
        }
        catch (IllegalArgumentException theVersionOfAsmIsOlderThanWeRequire) {
            return null;
        }
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ActualValueInference.class.getClassLoader());
        InputStream stream = null;
        try {
            stream = loader.getResourceAsStream(className.replace('.', '/') + ".class");
            new ClassReader(stream).accept((ClassVisitor)visitor, 0);
            ImmutableSet actualsAtLine = visitor.actualValueAtLine.build().get((Object)lineNumber);
            String string = actualsAtLine.size() == 1 ? ((StackEntry)Iterables.getOnlyElement((Iterable)actualsAtLine)).description() : null;
            ActualValueInference.closeQuietly(stream);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        catch (SecurityException e2) {
            String string = null;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ActualValueInference.closeQuietly(stream);
        }
    }

    private static StackEntry opaque(InferredType type) {
        return new AutoValue_ActualValueInference_OpaqueEntry(type);
    }

    private static StackEntry described(InferredType type, String description) {
        return new AutoValue_ActualValueInference_DescribedEntry(type, description);
    }

    private static StackEntry subjectFor(InferredType type, StackEntry actual) {
        return new AutoValue_ActualValueInference_SubjectEntry(type, actual);
    }

    private static boolean isThatOrAssertThat(String owner, String name) {
        return owner.equals("com/google/common/truth/Truth") && name.equals("assertThat") || owner.equals("com/google/common/truth/StandardSubjectBuilder") && name.equals("that") || owner.equals("com/google/common/truth/SimpleSubjectBuilder") && name.equals("that");
    }

    private static boolean isBoxing(String owner, String name, String desc) {
        return name.equals("valueOf") && PRIMITIVE_WRAPPERS.contains((Object)owner) && !Type.getArgumentTypes((String)desc)[0].equals((Object)Type.getType(String.class));
    }

    private static boolean isStatic(int access) {
        return ActualValueInference.isSet(access, 8);
    }

    private static boolean isSet(int flags, int bitmask) {
        return (flags & bitmask) == bitmask;
    }

    private static void closeQuietly(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ActualValueInference() {
    }

    private static final class InferenceClassVisitor
    extends ClassVisitor {
        private final String methodNameToVisit;
        private final ImmutableSetMultimap.Builder<Integer, StackEntry> actualValueAtLine = ImmutableSetMultimap.builder();
        private String className;

        InferenceClassVisitor(String methodNameToVisit) {
            super(458752);
            this.methodNameToVisit = methodNameToVisit;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.methodNameToVisit.equals(name) ? new InferenceMethodVisitor(access, this.className, name, desc, this.actualValueAtLine) : null;
        }
    }

    static abstract class StackEntry {
        StackEntry() {
        }

        abstract InferredType type();

        boolean isSubject() {
            return false;
        }

        StackEntry actualValue() {
            throw new ClassCastException(this.getClass().getName());
        }

        String description() {
            return null;
        }
    }

    @GwtIncompatible
    static abstract class InferredType {
        static final String UNINITIALIZED_PREFIX = "UNINIT@";
        static final InferredType BOOLEAN = new AutoValue_ActualValueInference_InferredType("Z");
        static final InferredType BYTE = new AutoValue_ActualValueInference_InferredType("B");
        static final InferredType INT = new AutoValue_ActualValueInference_InferredType("I");
        static final InferredType FLOAT = new AutoValue_ActualValueInference_InferredType("F");
        static final InferredType LONG = new AutoValue_ActualValueInference_InferredType("J");
        static final InferredType DOUBLE = new AutoValue_ActualValueInference_InferredType("D");
        static final InferredType TOP = new AutoValue_ActualValueInference_InferredType("TOP");
        static final InferredType NULL = new AutoValue_ActualValueInference_InferredType("NULL");
        static final InferredType UNINITIALIZED_THIS = new AutoValue_ActualValueInference_InferredType("UNINITIALIZED_THIS");
        static final InferredType UNINITIALIZED = new AutoValue_ActualValueInference_InferredType("UNINIT@");

        InferredType() {
        }

        static InferredType create(String descriptor) {
            if (UNINITIALIZED_PREFIX.equals(descriptor)) {
                return UNINITIALIZED;
            }
            char firstChar = descriptor.charAt(0);
            if (firstChar == 'L' || firstChar == '[') {
                return new AutoValue_ActualValueInference_InferredType(descriptor);
            }
            switch (descriptor) {
                case "Z": {
                    return BOOLEAN;
                }
                case "B": {
                    return BYTE;
                }
                case "I": {
                    return INT;
                }
                case "F": {
                    return FLOAT;
                }
                case "J": {
                    return LONG;
                }
                case "D": {
                    return DOUBLE;
                }
                case "TOP": {
                    return TOP;
                }
                case "NULL": {
                    return NULL;
                }
                case "UNINITIALIZED_THIS": {
                    return UNINITIALIZED_THIS;
                }
            }
            throw new RuntimeException("Invalid descriptor: " + descriptor);
        }

        abstract String descriptor();

        public final String toString() {
            return this.descriptor();
        }

        boolean isCategory2() {
            String descriptor = this.descriptor();
            return descriptor.equals("J") || descriptor.equals("D");
        }

        InferredType getElementTypeIfArrayOrThrow() {
            String descriptor = this.descriptor();
            Preconditions.checkState((descriptor.charAt(0) == '[' ? 1 : 0) != 0, (String)"This type %s is not an array.", (Object)this);
            return InferredType.create(descriptor.substring(1));
        }

        boolean isUninitialized() {
            return this.descriptor().startsWith(UNINITIALIZED_PREFIX);
        }
    }

    @GwtIncompatible
    static abstract class Invocation {
        Invocation() {
        }

        static Builder builder(String name) {
            return new AutoValue_ActualValueInference_Invocation.Builder().setName(name);
        }

        abstract StackEntry receiver();

        abstract StackEntry actualValue();

        abstract StackEntry boxingInput();

        abstract String name();

        final StackEntry deriveEntry(InferredType type, boolean hasParams) {
            if (this.boxingInput() != null && this.boxingInput().description() != null) {
                return ActualValueInference.described(type, this.boxingInput().description());
            }
            if (this.actualValue() != null) {
                return ActualValueInference.subjectFor(type, this.actualValue());
            }
            if (this.isOnSubjectInstance()) {
                return ActualValueInference.subjectFor(type, this.receiver().actualValue());
            }
            if (BORING_NAMES.contains((Object)this.name())) {
                return ActualValueInference.opaque(type);
            }
            return ActualValueInference.described(type, this.name() + (hasParams ? "(...)" : "()"));
        }

        final boolean isOnSubjectInstance() {
            return this.receiver() != null && this.receiver().isSubject();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setReceiver(StackEntry var1);

            abstract Builder setActualValue(StackEntry var1);

            abstract Builder setBoxingInput(StackEntry var1);

            abstract Builder setName(String var1);

            abstract Invocation build();
        }
    }

    @GwtIncompatible
    static abstract class FrameInfo {
        FrameInfo() {
        }

        static FrameInfo create(ImmutableList<StackEntry> locals, ImmutableList<StackEntry> stack) {
            return new AutoValue_ActualValueInference_FrameInfo(locals, stack);
        }

        abstract ImmutableList<StackEntry> locals();

        abstract ImmutableList<StackEntry> stack();
    }

    private static final class InferenceMethodVisitor
    extends MethodVisitor {
        private boolean used = false;
        private final ArrayList<StackEntry> localVariableSlots;
        private final ArrayList<StackEntry> operandStack = new ArrayList();
        private FrameInfo previousFrame;
        private final String methodSignature;
        private final ImmutableList.Builder<Label> labelsSeen = ImmutableList.builder();
        private final ImmutableSetMultimap.Builder<Label, Integer> lineNumbersAtLabel = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<ImmutableList<Label>, StackEntry> actualValueAtLocation = ImmutableSetMultimap.builder();
        private boolean seenJump;
        private final ImmutableSetMultimap.Builder<Integer, StackEntry> actualValueAtLine;

        InferenceMethodVisitor(int access, String owner, String name, String methodDescriptor, ImmutableSetMultimap.Builder<Integer, StackEntry> actualValueAtLine) {
            super(524288);
            this.localVariableSlots = InferenceMethodVisitor.createInitialLocalVariableSlots(access, owner, name, methodDescriptor);
            this.previousFrame = FrameInfo.create((ImmutableList<StackEntry>)ImmutableList.copyOf(this.localVariableSlots), (ImmutableList<StackEntry>)ImmutableList.of());
            this.methodSignature = owner + "." + name + methodDescriptor;
            this.actualValueAtLine = actualValueAtLine;
        }

        public void visitCode() {
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Cannot reuse this method visitor.");
            this.used = true;
            super.visitCode();
        }

        public void visitEnd() {
            if (this.seenJump) {
                super.visitEnd();
                return;
            }
            ImmutableSetMultimap lineNumbersAtLabel = this.lineNumbersAtLabel.build();
            for (Map.Entry e : this.actualValueAtLocation.build().entries()) {
                UnmodifiableIterator unmodifiableIterator = InferenceMethodVisitor.lineNumbers((ImmutableList<Label>)((ImmutableList)e.getKey()), (ImmutableSetMultimap<Label, Integer>)lineNumbersAtLabel).iterator();
                while (unmodifiableIterator.hasNext()) {
                    int lineNumber = (Integer)unmodifiableIterator.next();
                    this.actualValueAtLine.put((Object)lineNumber, (Object)((StackEntry)e.getValue()));
                }
            }
            super.visitEnd();
        }

        private static ImmutableSet<Integer> lineNumbers(ImmutableList<Label> labels, ImmutableSetMultimap<Label, Integer> lineNumbersAtLabel) {
            for (Label label : labels.reverse()) {
                if (!lineNumbersAtLabel.containsKey((Object)label)) continue;
                return lineNumbersAtLabel.get((Object)label);
            }
            return ImmutableSet.of();
        }

        public void visitLineNumber(int line, Label start) {
            this.lineNumbersAtLabel.put((Object)start, (Object)line);
            super.visitLineNumber(line, start);
        }

        public void visitLabel(Label label) {
            this.labelsSeen.add((Object)label);
            super.visitLabel(label);
        }

        private StackEntry getOperandFromTop(int offsetFromTop) {
            int index = this.operandStack.size() - 1 - offsetFromTop;
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"Invalid offset %s in the list of size %s. The current method is %s", (Object)offsetFromTop, (Object)this.operandStack.size(), (Object)this.methodSignature);
            return this.operandStack.get(index);
        }

        public void visitInsn(int opcode) {
            switch (opcode) {
                case 0: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 145: 
                case 146: 
                case 147: 
                case 177: {
                    break;
                }
                case 1: {
                    this.push(InferredType.NULL);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.push(InferredType.INT);
                    break;
                }
                case 9: 
                case 10: {
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.push(InferredType.FLOAT);
                    break;
                }
                case 14: 
                case 15: {
                    this.push(InferredType.DOUBLE);
                    this.push(InferredType.TOP);
                    break;
                }
                case 46: 
                case 51: 
                case 52: 
                case 53: {
                    this.pop(2);
                    this.push(InferredType.INT);
                    break;
                }
                case 47: 
                case 143: {
                    this.pop(2);
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 49: 
                case 138: {
                    this.pop(2);
                    this.push(InferredType.DOUBLE);
                    this.push(InferredType.TOP);
                    break;
                }
                case 50: {
                    InferredType arrayType = this.pop(2).type();
                    InferredType elementType = arrayType.getElementTypeIfArrayOrThrow();
                    this.push(elementType);
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    break;
                }
                case 80: 
                case 82: {
                    this.pop(4);
                    break;
                }
                case 87: 
                case 172: 
                case 174: 
                case 176: 
                case 191: 
                case 194: 
                case 195: {
                    this.pop();
                    break;
                }
                case 88: 
                case 173: 
                case 175: {
                    this.pop(2);
                    break;
                }
                case 89: {
                    this.push(this.top());
                    break;
                }
                case 90: {
                    StackEntry top = this.pop();
                    StackEntry next = this.pop();
                    this.push(top);
                    this.push(next);
                    this.push(top);
                    break;
                }
                case 91: {
                    StackEntry top = this.pop();
                    StackEntry next = this.pop();
                    StackEntry bottom = this.pop();
                    this.push(top);
                    this.push(bottom);
                    this.push(next);
                    this.push(top);
                    break;
                }
                case 92: {
                    StackEntry top = this.pop();
                    StackEntry next = this.pop();
                    this.push(next);
                    this.push(top);
                    this.push(next);
                    this.push(top);
                    break;
                }
                case 93: {
                    StackEntry top = this.pop();
                    StackEntry next = this.pop();
                    StackEntry bottom = this.pop();
                    this.push(next);
                    this.push(top);
                    this.push(bottom);
                    this.push(next);
                    this.push(top);
                    break;
                }
                case 94: {
                    StackEntry t1 = this.pop();
                    StackEntry t2 = this.pop();
                    StackEntry t3 = this.pop();
                    StackEntry t4 = this.pop();
                    this.push(t2);
                    this.push(t1);
                    this.push(t4);
                    this.push(t3);
                    this.push(t2);
                    this.push(t1);
                    break;
                }
                case 95: {
                    StackEntry top = this.pop();
                    StackEntry next = this.pop();
                    this.push(top);
                    this.push(next);
                    break;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: 
                case 136: 
                case 142: 
                case 149: 
                case 150: {
                    this.pop(2);
                    this.push(InferredType.INT);
                    break;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 127: 
                case 129: 
                case 131: {
                    this.pop(4);
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 121: 
                case 123: 
                case 125: {
                    this.pop(3);
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 133: 
                case 140: {
                    this.pop();
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 134: {
                    this.pop();
                    this.push(InferredType.FLOAT);
                    break;
                }
                case 148: 
                case 151: 
                case 152: {
                    this.pop(4);
                    this.push(InferredType.INT);
                    break;
                }
                case 135: 
                case 141: {
                    this.pop();
                    this.push(InferredType.DOUBLE);
                    this.push(InferredType.TOP);
                    break;
                }
                case 139: 
                case 190: {
                    this.pop();
                    this.push(InferredType.INT);
                    break;
                }
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 137: 
                case 144: {
                    this.pop(2);
                    this.push(InferredType.FLOAT);
                    break;
                }
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: {
                    this.pop(4);
                    this.push(InferredType.DOUBLE);
                    this.push(InferredType.TOP);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode);
                }
            }
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            block0 : switch (opcode) {
                case 16: 
                case 17: {
                    this.push(InferredType.INT);
                    break;
                }
                case 188: {
                    this.pop();
                    switch (operand) {
                        case 4: {
                            this.pushDescriptor("[Z");
                            break block0;
                        }
                        case 5: {
                            this.pushDescriptor("[C");
                            break block0;
                        }
                        case 6: {
                            this.pushDescriptor("[F");
                            break block0;
                        }
                        case 7: {
                            this.pushDescriptor("[D");
                            break block0;
                        }
                        case 8: {
                            this.pushDescriptor("[B");
                            break block0;
                        }
                        case 9: {
                            this.pushDescriptor("[S");
                            break block0;
                        }
                        case 10: {
                            this.pushDescriptor("[I");
                            break block0;
                        }
                        case 11: {
                            this.pushDescriptor("[J");
                            break block0;
                        }
                    }
                    throw new RuntimeException("Unhandled operand value: " + operand);
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode);
                }
            }
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            switch (opcode) {
                case 21: {
                    this.push(InferredType.INT);
                    break;
                }
                case 22: {
                    this.push(InferredType.LONG);
                    this.push(InferredType.TOP);
                    break;
                }
                case 23: {
                    this.push(InferredType.FLOAT);
                    break;
                }
                case 24: {
                    this.push(InferredType.DOUBLE);
                    this.push(InferredType.TOP);
                    break;
                }
                case 25: {
                    this.push(this.getLocalVariable(var));
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    StackEntry entry = this.pop();
                    this.setLocalVariable(var, entry);
                    break;
                }
                case 55: 
                case 57: {
                    StackEntry entry = this.pop(2);
                    this.setLocalVariable(var, entry);
                    this.setLocalVariable(var + 1, ActualValueInference.opaque(InferredType.TOP));
                    break;
                }
                case 169: {
                    throw new RuntimeException("The instruction RET is not supported");
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode);
                }
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            String descriptor = InferenceMethodVisitor.convertToDescriptor(type);
            switch (opcode) {
                case 187: {
                    this.pushDescriptor(descriptor);
                    break;
                }
                case 189: {
                    this.pop();
                    this.pushDescriptor("[" + descriptor);
                    break;
                }
                case 192: {
                    this.pop();
                    this.pushDescriptor(descriptor);
                    break;
                }
                case 193: {
                    this.pop();
                    this.push(InferredType.INT);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode);
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            switch (opcode) {
                case 178: {
                    this.pushDescriptor(desc);
                    break;
                }
                case 179: {
                    this.popDescriptor(desc);
                    break;
                }
                case 180: {
                    this.pop();
                    this.pushDescriptor(desc);
                    break;
                }
                case 181: {
                    this.popDescriptor(desc);
                    this.pop();
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode + ", owner=" + owner + ", name=" + name + ", desc" + desc);
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            int argumentSize;
            InferredType receiverType;
            if (opcode == 183 && "<init>".equals(name) && (receiverType = this.getOperandFromTop((argumentSize = Type.getArgumentsAndReturnSizes((String)desc) >> 2) - 1).type()).isUninitialized()) {
                InferredType realType = InferredType.create("L" + owner + ";");
                this.replaceUninitializedTypeInStack(receiverType, realType);
            }
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Invocation.Builder invocation = Invocation.builder(name);
                    if (ActualValueInference.isThatOrAssertThat(owner, name)) {
                        invocation.setActualValue(this.getOperandFromTop(0));
                    } else if (ActualValueInference.isBoxing(owner, name, desc)) {
                        invocation.setBoxingInput(this.getOperandFromTop(0).type() == InferredType.TOP ? this.getOperandFromTop(1) : this.getOperandFromTop(0));
                    }
                    this.popDescriptor(desc);
                    if (opcode != 184) {
                        invocation.setReceiver(this.pop());
                    }
                    this.pushDescriptorAndMaybeProcessMethodCall(desc, invocation.build());
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unhandled opcode %s, owner=%s, name=%s, desc=%s, itf=%s", opcode, owner, name, desc, itf));
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.popDescriptor(desc);
            this.pushDescriptor(desc);
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.seenJump = true;
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.pop();
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.pop(2);
                    break;
                }
                case 167: {
                    break;
                }
                case 168: {
                    throw new RuntimeException("The JSR instruction is not supported.");
                }
                case 198: 
                case 199: {
                    this.pop(1);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled opcode " + opcode);
                }
            }
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Integer) {
                this.push(InferredType.INT);
            } else if (cst instanceof Float) {
                this.push(InferredType.FLOAT);
            } else if (cst instanceof Long) {
                this.push(InferredType.LONG);
                this.push(InferredType.TOP);
            } else if (cst instanceof Double) {
                this.push(InferredType.DOUBLE);
                this.push(InferredType.TOP);
            } else if (cst instanceof String) {
                this.pushDescriptor("Ljava/lang/String;");
            } else if (cst instanceof Type) {
                this.pushDescriptor(((Type)cst).getDescriptor());
            } else if (cst instanceof Handle) {
                this.pushDescriptor("Ljava/lang/invoke/MethodHandle;");
            } else {
                throw new RuntimeException("Cannot handle constant " + cst + " for LDC instruction");
            }
            super.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.setLocalVariable(var, ActualValueInference.opaque(InferredType.INT));
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.seenJump = true;
            this.pop();
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.seenJump = true;
            this.pop();
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.seenJump = true;
            super.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.pop(dims);
            this.pushDescriptor(desc);
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            switch (type) {
                case -1: {
                    this.previousFrame = FrameInfo.create(this.convertTypesInStackMapFrame(nLocal, local), this.convertTypesInStackMapFrame(nStack, stack));
                    break;
                }
                case 3: {
                    this.previousFrame = FrameInfo.create(this.previousFrame.locals(), (ImmutableList<StackEntry>)ImmutableList.of());
                    break;
                }
                case 4: {
                    this.previousFrame = FrameInfo.create(this.previousFrame.locals(), this.convertTypesInStackMapFrame(nStack, stack));
                    break;
                }
                case 1: {
                    this.previousFrame = FrameInfo.create(this.appendArrayToList(this.previousFrame.locals(), nLocal, local), (ImmutableList<StackEntry>)ImmutableList.of());
                    break;
                }
                case 2: {
                    this.previousFrame = FrameInfo.create(InferenceMethodVisitor.removeBackFromList(this.previousFrame.locals(), nLocal), (ImmutableList<StackEntry>)ImmutableList.of());
                    break;
                }
                case 0: {
                    this.previousFrame = FrameInfo.create(this.convertTypesInStackMapFrame(nLocal, local), this.convertTypesInStackMapFrame(nStack, stack));
                    break;
                }
            }
            this.operandStack.clear();
            this.operandStack.addAll((Collection<StackEntry>)this.previousFrame.stack());
            this.localVariableSlots.clear();
            this.localVariableSlots.addAll((Collection<StackEntry>)this.previousFrame.locals());
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        private static String convertToDescriptor(String type) {
            return type.length() > 1 && type.charAt(0) != '[' ? "L" + type + ";" : type;
        }

        private void push(InferredType type) {
            this.push(ActualValueInference.opaque(type));
        }

        private void push(StackEntry entry) {
            this.operandStack.add(entry);
        }

        private void replaceUninitializedTypeInStack(InferredType oldType, InferredType newType) {
            Preconditions.checkArgument((boolean)oldType.isUninitialized(), (String)"The old type is NOT uninitialized. %s", (Object)oldType);
            int size = this.operandStack.size();
            for (int i = 0; i < size; ++i) {
                InferredType type = this.operandStack.get(i).type();
                if (!type.equals(oldType)) continue;
                this.operandStack.set(i, ActualValueInference.opaque(newType));
            }
        }

        private void pushDescriptor(String desc) {
            this.pushDescriptorAndMaybeProcessMethodCall(desc, null);
        }

        private void pushDescriptorAndMaybeProcessMethodCall(String desc, Invocation invocation) {
            if (invocation != null && invocation.isOnSubjectInstance()) {
                this.actualValueAtLocation.put((Object)this.labelsSeen.build(), (Object)invocation.receiver().actualValue());
            }
            boolean hasParams = invocation != null && Type.getArgumentsAndReturnSizes((String)desc) >> 2 > 1;
            int index = desc.charAt(0) == '(' ? desc.indexOf(41) + 1 : 0;
            switch (desc.charAt(index)) {
                case 'V': {
                    return;
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.pushMaybeDescribed(InferredType.INT, invocation, hasParams);
                    break;
                }
                case 'F': {
                    this.pushMaybeDescribed(InferredType.FLOAT, invocation, hasParams);
                    break;
                }
                case 'D': {
                    this.pushMaybeDescribed(InferredType.DOUBLE, invocation, hasParams);
                    this.push(InferredType.TOP);
                    break;
                }
                case 'J': {
                    this.pushMaybeDescribed(InferredType.LONG, invocation, hasParams);
                    this.push(InferredType.TOP);
                    break;
                }
                case 'L': 
                case '[': {
                    this.pushMaybeDescribed(InferredType.create(desc.substring(index)), invocation, hasParams);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled type: " + desc);
                }
            }
        }

        private void pushMaybeDescribed(InferredType type, Invocation invocation, boolean hasParams) {
            this.push(invocation == null ? ActualValueInference.opaque(type) : invocation.deriveEntry(type, hasParams));
        }

        private StackEntry pop() {
            return this.pop(1);
        }

        private StackEntry pop(int count) {
            Preconditions.checkArgument((count >= 1 ? 1 : 0) != 0, (String)"The count should be at least one: %s (In %s)", (int)count, (Object)this.methodSignature);
            Preconditions.checkState((this.operandStack.size() >= count ? 1 : 0) != 0, (String)"There are no enough elements in the stack. count=%s, stack=%s (In %s)", (Object)count, this.operandStack, (Object)this.methodSignature);
            int expectedLastIndex = this.operandStack.size() - count - 1;
            StackEntry lastPopped = null;
            for (int i = this.operandStack.size() - 1; i > expectedLastIndex; --i) {
                lastPopped = this.operandStack.remove(i);
            }
            return lastPopped;
        }

        private void popDescriptor(String desc) {
            char c = desc.charAt(0);
            switch (c) {
                case '(': {
                    int argumentSize = (Type.getArgumentsAndReturnSizes((String)desc) >> 2) - 1;
                    if (argumentSize <= 0) break;
                    this.pop(argumentSize);
                    break;
                }
                case 'D': 
                case 'J': {
                    this.pop(2);
                    break;
                }
                default: {
                    this.pop(1);
                }
            }
        }

        private StackEntry getLocalVariable(int index) {
            Preconditions.checkState((index < this.localVariableSlots.size() ? 1 : 0) != 0, (String)"Cannot find type for var %s in method %s", (int)index, (Object)this.methodSignature);
            return this.localVariableSlots.get(index);
        }

        private void setLocalVariable(int index, StackEntry entry) {
            while (this.localVariableSlots.size() <= index) {
                this.localVariableSlots.add(ActualValueInference.opaque(InferredType.TOP));
            }
            this.localVariableSlots.set(index, entry);
        }

        private StackEntry top() {
            return this.operandStack.get(this.operandStack.size() - 1);
        }

        private static ArrayList<StackEntry> createInitialLocalVariableSlots(int access, String ownerClass, String methodName, String methodDescriptor) {
            Type[] argumentTypes;
            ArrayList<StackEntry> entries = new ArrayList<StackEntry>();
            if (!ActualValueInference.isStatic(access)) {
                entries.add(ActualValueInference.opaque(InferredType.create(InferenceMethodVisitor.convertToDescriptor(ownerClass))));
            }
            block7: for (Type argumentType : argumentTypes = Type.getArgumentTypes((String)methodDescriptor)) {
                switch (argumentType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        entries.add(ActualValueInference.opaque(InferredType.INT));
                        continue block7;
                    }
                    case 6: {
                        entries.add(ActualValueInference.opaque(InferredType.FLOAT));
                        continue block7;
                    }
                    case 7: {
                        entries.add(ActualValueInference.opaque(InferredType.LONG));
                        entries.add(ActualValueInference.opaque(InferredType.TOP));
                        continue block7;
                    }
                    case 8: {
                        entries.add(ActualValueInference.opaque(InferredType.DOUBLE));
                        entries.add(ActualValueInference.opaque(InferredType.TOP));
                        continue block7;
                    }
                    case 9: 
                    case 10: {
                        entries.add(ActualValueInference.opaque(InferredType.create(argumentType.getDescriptor())));
                        continue block7;
                    }
                    default: {
                        throw new RuntimeException("Unhandled argument type: " + argumentType + " in " + ownerClass + "." + methodName + methodDescriptor);
                    }
                }
            }
            return entries;
        }

        private static ImmutableList<StackEntry> removeBackFromList(ImmutableList<StackEntry> list, int countToRemove) {
            int index;
            int origSize = list.size();
            for (index = origSize - 1; index >= 0 && countToRemove > 0; --index, --countToRemove) {
                InferredType type = ((StackEntry)list.get(index)).type();
                if (!type.equals(InferredType.TOP) || index <= 0 || !((StackEntry)list.get(index - 1)).type().isCategory2()) continue;
                --index;
            }
            Preconditions.checkState((countToRemove == 0 ? 1 : 0) != 0, (String)"countToRemove is %s but not 0. index=%s, list=%s", (Object)countToRemove, (Object)index, list);
            return list.subList(0, index + 1);
        }

        private ImmutableList<StackEntry> appendArrayToList(ImmutableList<StackEntry> list, int size, Object[] array) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(list);
            for (int i = 0; i < size; ++i) {
                InferredType type = this.convertTypeInStackMapFrame(array[i]);
                builder.add((Object)ActualValueInference.opaque(type));
                if (!type.isCategory2()) continue;
                builder.add((Object)ActualValueInference.opaque(InferredType.TOP));
            }
            return builder.build();
        }

        private InferredType convertTypeInStackMapFrame(Object typeInStackMapFrame) {
            if (typeInStackMapFrame == Opcodes.TOP) {
                return InferredType.TOP;
            }
            if (typeInStackMapFrame == Opcodes.INTEGER) {
                return InferredType.INT;
            }
            if (typeInStackMapFrame == Opcodes.FLOAT) {
                return InferredType.FLOAT;
            }
            if (typeInStackMapFrame == Opcodes.DOUBLE) {
                return InferredType.DOUBLE;
            }
            if (typeInStackMapFrame == Opcodes.LONG) {
                return InferredType.LONG;
            }
            if (typeInStackMapFrame == Opcodes.NULL) {
                return InferredType.NULL;
            }
            if (typeInStackMapFrame == Opcodes.UNINITIALIZED_THIS) {
                return InferredType.UNINITIALIZED_THIS;
            }
            if (typeInStackMapFrame instanceof String) {
                String referenceTypeName = (String)typeInStackMapFrame;
                if (referenceTypeName.charAt(0) == '[') {
                    return InferredType.create(referenceTypeName);
                }
                return InferredType.create("L" + referenceTypeName + ";");
            }
            if (typeInStackMapFrame instanceof Label) {
                return InferredType.UNINITIALIZED;
            }
            throw new RuntimeException("Cannot reach here. Unhandled element: value=" + typeInStackMapFrame + ", class=" + typeInStackMapFrame.getClass() + ". The current method being desugared is " + this.methodSignature);
        }

        private ImmutableList<StackEntry> convertTypesInStackMapFrame(int size, Object[] array) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                InferredType type = this.convertTypeInStackMapFrame(array[i]);
                builder.add((Object)ActualValueInference.opaque(type));
                if (!type.isCategory2()) continue;
                builder.add((Object)ActualValueInference.opaque(InferredType.TOP));
            }
            return builder.build();
        }
    }

    @GwtIncompatible
    static abstract class SubjectEntry
    extends StackEntry {
        SubjectEntry() {
        }

        @Override
        abstract StackEntry actualValue();

        @Override
        final boolean isSubject() {
            return true;
        }

        public final String toString() {
            return String.format("subjectFor(%s)", this.actualValue());
        }
    }

    @GwtIncompatible
    static abstract class DescribedEntry
    extends StackEntry {
        DescribedEntry() {
        }

        @Override
        abstract String description();

        public final String toString() {
            return this.description();
        }
    }

    @GwtIncompatible
    static abstract class OpaqueEntry
    extends StackEntry {
        OpaqueEntry() {
        }

        public final String toString() {
            return "unknown";
        }
    }
}

