/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Fact;
import com.google.common.truth.Platform;
import com.google.common.truth.SubjectUtils;

final class ComparisonFailures {
    private static final int CONTEXT = 20;
    private static final int WORTH_HIDING = 60;

    static ImmutableList<Fact> makeComparisonFailureFacts(ImmutableList<Fact> headFacts, ImmutableList<Fact> tailFacts, String expected, String actual) {
        return SubjectUtils.concat(new Iterable[]{headFacts, ComparisonFailures.formatExpectedAndActual(expected, actual), tailFacts});
    }

    @VisibleForTesting
    static ImmutableList<Fact> formatExpectedAndActual(String expected, String actual) {
        ImmutableList<Fact> result = Platform.makeDiff(expected, actual);
        if (result != null) {
            return result;
        }
        result = ComparisonFailures.removeCommonPrefixAndSuffix(expected, actual);
        if (result != null) {
            return result;
        }
        return ImmutableList.of((Object)Fact.fact("expected", expected), (Object)Fact.fact("but was", actual));
    }

    private static ImmutableList<Fact> removeCommonPrefixAndSuffix(String expected, String actual) {
        int originalExpectedLength = ((String)expected).length();
        int prefix = Strings.commonPrefix((CharSequence)expected, (CharSequence)actual).length();
        for (prefix = Math.max(0, prefix - 20); prefix > 0 && ComparisonFailures.validSurrogatePairAt((CharSequence)expected, prefix - 1); --prefix) {
        }
        if (prefix > 3) {
            expected = "\u2026" + ((String)expected).substring(prefix);
            actual = "\u2026" + ((String)actual).substring(prefix);
        }
        int suffix = Strings.commonSuffix((CharSequence)expected, (CharSequence)actual).length();
        for (suffix = Math.max(0, suffix - 20); suffix > 0 && ComparisonFailures.validSurrogatePairAt((CharSequence)expected, ((String)expected).length() - suffix - 1); --suffix) {
        }
        if (suffix > 3) {
            expected = ((String)expected).substring(0, ((String)expected).length() - suffix) + "\u2026";
            actual = ((String)actual).substring(0, ((String)actual).length() - suffix) + "\u2026";
        }
        if (originalExpectedLength - ((String)expected).length() < 60) {
            return null;
        }
        return ImmutableList.of((Object)Fact.fact("expected", expected), (Object)Fact.fact("but was", actual));
    }

    private static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    private ComparisonFailures() {
    }
}

