/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;

public final class Fact
implements Serializable {
    final String key;
    final String value;

    public static Fact fact(String key, Object value) {
        return new Fact(key, String.valueOf(value));
    }

    public static Fact simpleFact(String key) {
        return new Fact(key, null);
    }

    private Fact(String key, String value) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = value;
    }

    public String toString() {
        return this.value == null ? this.key : this.key + ": " + this.value;
    }

    static String makeMessage(ImmutableList<String> messages, ImmutableList<Fact> facts) {
        int longestKeyLength = 0;
        boolean seenNewlineInValue = false;
        for (Fact fact : facts) {
            if (fact.value == null) continue;
            longestKeyLength = Math.max(longestKeyLength, fact.key.length());
            seenNewlineInValue |= fact.value.contains("\n");
        }
        StringBuilder builder = new StringBuilder();
        for (String message : messages) {
            builder.append(message);
            builder.append('\n');
        }
        for (Fact fact : facts) {
            if (fact.value == null) {
                builder.append(fact.key);
            } else if (seenNewlineInValue) {
                builder.append(fact.key);
                builder.append(":\n");
                builder.append(Fact.indent(fact.value));
            } else {
                builder.append(Strings.padEnd((String)fact.key, (int)longestKeyLength, (char)' '));
                builder.append(": ");
                builder.append(fact.value);
            }
            builder.append('\n');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String indent(String value) {
        return "    " + value.replaceAll("\n", "\n    ");
    }
}

