/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class MultiMap<K, V> {
    private final Set<V> set;
    private final Map<K, Set<V>> map;

    MultiMap(Set<V> set, Map<K, Set<V>> map) {
        this.set = set;
        this.map = map;
    }

    static <K, V> MultiMap<K, V> create() {
        return new MultiMap(new LinkedHashSet(), new LinkedHashMap());
    }

    static <K, V> MultiMap<K, V> copyOf(Map<K, Set<V>> map) {
        MultiMap result = MultiMap.create();
        map.forEach((k, values) -> values.forEach(v -> result.put(k, v)));
        return result;
    }

    void put(K key, V value) {
        this.map.compute(key, (k, v) -> {
            if (v == null) {
                v = new LinkedHashSet<Object>();
            }
            if (v.add(value)) {
                this.set.add(value);
            }
            return v;
        });
    }

    Set<V> flatValues() {
        return this.set;
    }

    Collection<Set<V>> values() {
        return this.map.values();
    }

    Stream<Map.Entry<K, V>> stream() {
        final Iterator<Map.Entry<K, Set<V>>> iterator = this.map.entrySet().iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Map.Entry<K, V>>(){
            Map.Entry<K, Set<V>> current;
            Iterator<V> setIterator;
            {
                this.current = (Map.Entry)iterator.next();
                this.setIterator = this.current.getValue().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.setIterator.hasNext()) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                    this.setIterator = this.current.getValue().iterator();
                    if (!this.setIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<K, V> next() {
                return new AbstractMap.SimpleImmutableEntry(this.current.getKey(), this.setIterator.next());
            }
        }, 16), false);
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    Map<K, Set<V>> asMap() {
        return this.map;
    }

    Set<V> get(K key) {
        return this.map.get(key);
    }

    boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

