/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class GraphMatching {
    static <U, V> Map<U, V> maximumCardinalityBipartiteMatching(Map<U, Set<V>> graph) {
        return HopcroftKarp.overBipartiteGraph(graph).perform();
    }

    private GraphMatching() {
    }

    private static class HopcroftKarp<U, V> {
        private final Map<U, Set<V>> graph;

        static <U, V> HopcroftKarp<U, V> overBipartiteGraph(Map<U, Set<V>> graph) {
            return new HopcroftKarp<U, V>(graph);
        }

        private HopcroftKarp(Map<U, Set<V>> graph) {
            this.graph = graph;
        }

        Map<U, V> perform() {
            HashMap layers;
            Optional<Integer> freeRhsVertexLayer;
            LinkedHashMap matching = new LinkedHashMap();
            while (!(freeRhsVertexLayer = this.breadthFirstSearch(matching, layers = new HashMap())).isEmpty()) {
                for (U lhs : this.graph.keySet()) {
                    if (matching.containsKey(lhs)) continue;
                    this.depthFirstSearch(matching, layers, freeRhsVertexLayer.get(), lhs);
                }
            }
            return matching;
        }

        private Optional<Integer> breadthFirstSearch(Map<U, V> matching, Map<U, Integer> layers) {
            ArrayDeque<U> queue = new ArrayDeque<U>();
            Optional<Integer> freeRhsVertexLayer = Optional.empty();
            for (U lhs : this.graph.keySet()) {
                if (matching.containsKey(lhs)) continue;
                layers.put(lhs, 1);
                queue.add(lhs);
            }
            while (!queue.isEmpty()) {
                Object lhs = queue.remove();
                int layer = layers.get(lhs);
                if (freeRhsVertexLayer.isPresent() && layer > freeRhsVertexLayer.get()) break;
                for (Object rhs : this.graph.getOrDefault(lhs, Set.of())) {
                    if (!matching.containsValue(rhs)) {
                        if (!freeRhsVertexLayer.isEmpty()) continue;
                        freeRhsVertexLayer = Optional.of(layer);
                        continue;
                    }
                    Object nextLhs = matching.entrySet().stream().filter(e -> e.getValue().equals(rhs)).map(Map.Entry::getKey).findFirst().orElse(null);
                    if (layers.containsKey(nextLhs)) continue;
                    layers.put(nextLhs, layer + 1);
                    queue.add(nextLhs);
                }
            }
            return freeRhsVertexLayer;
        }

        private boolean depthFirstSearch(Map<U, V> matching, Map<U, Integer> layers, int freeRhsVertexLayer, U lhs) {
            int layer = layers.get(lhs);
            if (layer > freeRhsVertexLayer) {
                return false;
            }
            for (Object rhs : this.graph.getOrDefault(lhs, Set.of())) {
                if (!matching.containsValue(rhs)) {
                    matching.put(lhs, rhs);
                    return true;
                }
                Object nextLhs = matching.entrySet().stream().filter(e -> Objects.equals(e.getValue(), rhs)).map(Map.Entry::getKey).findFirst().orElseThrow();
                if (!layers.containsKey(nextLhs) || layers.get(nextLhs) != layer + 1 || !this.depthFirstSearch(matching, layers, freeRhsVertexLayer, nextLhs)) continue;
                matching.put(lhs, rhs);
                return true;
            }
            return false;
        }
    }
}

