/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.GraphMatching;
import com.google.common.truth.Ordered;
import com.google.common.truth.Preconditions;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IterableSubject
extends Subject {
    private final Iterable<?> actual;
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected IterableSubject(FailureMetadata metadata, Iterable<?> iterable) {
        super(metadata, iterable);
        this.actual = iterable;
    }

    @Override
    protected String actualCustomStringRepresentation() {
        if (this.actual != null) {
            String objectToString = this.actual.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.actual));
            if (this.actual.toString().equals(objectToString)) {
                return StreamSupport.stream(this.actual.spliterator(), false).collect(Collectors.toList()).toString();
            }
        }
        return super.actualCustomStringRepresentation();
    }

    @Override
    public void isEqualTo(Object expected) {
        boolean equal = Objects.equals(this.actual, expected);
        if (equal) {
            return;
        }
        if (this.actual instanceof List && expected instanceof List) {
            this.containsExactlyElementsIn((List)expected).inOrder();
        } else if (this.actual instanceof Set && expected instanceof Set) {
            this.containsExactlyElementsIn((Collection)expected);
        } else {
            super.isEqualTo(expected);
        }
    }

    public final void isEmpty() {
        if (this.actual.iterator().hasNext()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (!this.actual.iterator().hasNext()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize(%s) must be >= 0", expectedSize);
        int actualSize = IterableSubject.size(this.actual);
        this.check("size()", new Object[0]).that(actualSize).isEqualTo(expectedSize);
    }

    private static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            Preconditions.checkState(++count < Integer.MAX_VALUE);
        }
        return (int)count;
    }

    public final void contains(Object element) {
        boolean containsElement = StreamSupport.stream(this.actual.spliterator(), false).anyMatch(obj -> Objects.equals(element, obj));
        if (!containsElement) {
            ArrayList<Object> elementList = new ArrayList<Object>();
            elementList.add(element);
            if (SubjectUtils.hasMatchingToStringPair(this.actual, elementList)) {
                this.failWithoutActual(Fact.fact("expected to contain", element), Fact.fact("an instance of", SubjectUtils.objectToTypeName(element)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual, elementList))), this.fullContents());
            } else {
                this.failWithActual("expected to contain", element);
            }
        }
    }

    public final void doesNotContain(Object element) {
        boolean containsElement = StreamSupport.stream(this.actual.spliterator(), false).anyMatch(obj -> Objects.equals(element, obj));
        if (containsElement) {
            this.failWithActual("expected not to contain", element);
        }
    }

    public final void containsNoDuplicates() {
        LinkedHashMap multiset = new LinkedHashMap();
        for (Object entry : this.actual) {
            Integer count = multiset.getOrDefault(entry, 0);
            multiset.put(entry, count + 1);
        }
        Map<Object, Integer> duplicates = multiset.entrySet().stream().filter(e -> (Integer)e.getValue() >= 2).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!duplicates.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to contain duplicates"), Fact.fact("but contained", duplicates.entrySet().stream().map(e -> e.getKey() + " x " + e.getValue()).collect(Collectors.joining(",", "[", "]"))), this.fullContents());
        }
    }

    public final void containsAnyOf(Object first, Object second, Object ... rest) {
        this.containsAnyIn(SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsAnyIn(Iterable<?> expected) {
        Collection<?> actual = SubjectUtils.iterableToCollection(this.actual);
        for (Object item : expected) {
            if (!actual.contains(item)) continue;
            return;
        }
        if (SubjectUtils.hasMatchingToStringPair(actual, expected)) {
            this.failWithoutActual(Fact.fact("expected to contain any of", SubjectUtils.countDuplicatesAndAddTypeInfo(expected)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual, expected))), this.fullContents());
        } else {
            this.failWithActual("expected to contain any of", expected);
        }
    }

    public final void containsAnyIn(Object[] expected) {
        this.containsAnyIn(Arrays.asList(expected));
    }

    public final Ordered containsAtLeast(Object firstExpected, Object secondExpected, Object ... restOfExpected) {
        return this.containsAtLeastElementsIn(SubjectUtils.accumulate(firstExpected, secondExpected, restOfExpected));
    }

    public final Ordered containsAtLeastElementsIn(Collection<?> expectedIterable) {
        LinkedList actual = new LinkedList();
        this.actual.forEach(actual::add);
        final Collection<?> expected = SubjectUtils.iterableToCollection(expectedIterable);
        ArrayList missing = new ArrayList();
        ArrayList<Object> actualNotInOrder = new ArrayList<Object>();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            return this.failAtLeast(expected, missing);
        }
        return ordered ? IN_ORDER : new Ordered(){

            @Override
            public void inOrder() {
                IterableSubject.this.failWithActual(Fact.simpleFact("required elements were all found, but order was wrong"), Fact.fact("expected order for required elements", expected));
            }
        };
    }

    public final Ordered containsAtLeastElementsIn(Object[] expected) {
        return this.containsAtLeastElementsIn(Arrays.asList(expected));
    }

    private Ordered failAtLeast(Collection<?> expected, Collection<?> missingRawObjects) {
        List<Object> nearMissRawObjects = SubjectUtils.retainMatchingToString(this.actual, missingRawObjects);
        ArrayList<Fact> facts = new ArrayList<Fact>(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "though it did contain", nearMissRawObjects));
        facts.add(Fact.fact("expected to contain at least", expected));
        facts.add(this.butWas());
        this.failWithoutActual(facts);
        return ALREADY_FAILED;
    }

    private static void moveElements(List<?> input, Collection<Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    public final Ordered containsExactly(Object ... varargs) {
        List<Object> expected;
        if (varargs == null) {
            expected = new ArrayList<Object>();
            expected.add(null);
        } else {
            expected = Arrays.asList(varargs);
        }
        return this.containsExactlyElementsIn(expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    public final Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactlyElementsIn(expected, false);
    }

    public final Ordered containsExactlyElementsIn(Object[] expected) {
        return this.containsExactlyElementsIn(Arrays.asList(expected));
    }

    private Ordered containsExactlyElementsIn(final Iterable<?> required, boolean addElementsInWarning) {
        Iterator<?> actualIter = this.actual.iterator();
        Iterator<?> requiredIter = required.iterator();
        if (!requiredIter.hasNext()) {
            if (actualIter.hasNext()) {
                this.isEmpty();
                return ALREADY_FAILED;
            }
            return IN_ORDER;
        }
        boolean isFirst = true;
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (!Objects.equals(actualElement, requiredElement = requiredIter.next())) {
                if (isFirst && !actualIter.hasNext() && !requiredIter.hasNext()) {
                    this.checkNoNeedToDisplayBothValues("onlyElement()", new Object[0]).that(actualElement).failEqualityCheckForEqualsWithoutDescription(requiredElement);
                    return ALREADY_FAILED;
                }
                ArrayList missing = new ArrayList();
                missing.add(requiredElement);
                requiredIter.forEachRemaining(missing::add);
                ArrayList extra = new ArrayList();
                if (!missing.remove(actualElement)) {
                    extra.add(actualElement);
                }
                while (actualIter.hasNext()) {
                    Object item = actualIter.next();
                    if (missing.remove(item)) continue;
                    extra.add(item);
                }
                if (missing.isEmpty() && extra.isEmpty()) {
                    return new Ordered(){

                        @Override
                        public void inOrder() {
                            IterableSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("expected", required));
                        }
                    };
                }
                return this.failExactly(required, addElementsInWarning, missing, extra);
            }
            isFirst = false;
        }
        if (actualIter.hasNext()) {
            ArrayList extraRawObjects = new ArrayList();
            actualIter.forEachRemaining(extraRawObjects::add);
            return this.failExactly(required, addElementsInWarning, List.of(), extraRawObjects);
        }
        if (requiredIter.hasNext()) {
            ArrayList missingRawObjects = new ArrayList();
            requiredIter.forEachRemaining(missingRawObjects::add);
            return this.failExactly(required, addElementsInWarning, missingRawObjects, List.of());
        }
        return IN_ORDER;
    }

    private Ordered failExactly(Iterable<?> required, boolean addElementsInWarning, Collection<?> missingRawObjects, Collection<?> extraRawObjects) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "unexpected", extraRawObjects));
        facts.add(Fact.fact("expected", required));
        facts.add(this.butWas());
        if (addElementsInWarning) {
            facts.add(Fact.simpleFact("Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?"));
        }
        this.failWithoutActual(facts);
        return ALREADY_FAILED;
    }

    private static List<Fact> makeElementFactsForBoth(String firstKey, Collection<?> firstCollection, String secondKey, Collection<?> secondCollection) {
        boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(firstCollection, secondCollection);
        SubjectUtils.DuplicateGroupedAndTyped first = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(firstCollection, addTypeInfo);
        SubjectUtils.DuplicateGroupedAndTyped second = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(secondCollection, addTypeInfo);
        ElementFactGrouping grouping = IterableSubject.pickGrouping(first.entrySet(), second.entrySet());
        ArrayList<Fact> facts = new ArrayList<Fact>();
        List<Fact> firstFacts = IterableSubject.makeElementFacts(firstKey, first, grouping);
        List<Fact> secondFacts = IterableSubject.makeElementFacts(secondKey, second, grouping);
        facts.addAll(firstFacts);
        if (firstFacts.size() > 1 && secondFacts.size() > 1) {
            facts.add(Fact.simpleFact(""));
        }
        facts.addAll(secondFacts);
        facts.add(Fact.simpleFact("---"));
        return facts;
    }

    private static List<Fact> makeElementFacts(String label, SubjectUtils.DuplicateGroupedAndTyped elements, ElementFactGrouping grouping) {
        if (elements.isEmpty()) {
            return List.of();
        }
        if (grouping == ElementFactGrouping.ALL_IN_ONE_FACT) {
            return List.of(Fact.fact(IterableSubject.keyToGoWithElementsString(label, elements), elements));
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(Fact.simpleFact(IterableSubject.keyToServeAsHeader(label, elements)));
        int n = 1;
        for (Map.Entry<?, Integer> entry : elements.entrySet().entrySet()) {
            int count = entry.getValue();
            Object item = entry.getKey();
            facts.add(Fact.fact(IterableSubject.numberString(n, count), item));
            n += count;
        }
        return facts;
    }

    private static String keyToGoWithElementsString(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        return String.format("%s (%d)", label, elements.totalCopies());
    }

    private static String keyToServeAsHeader(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        Object key = IterableSubject.keyToGoWithElementsString(label, elements);
        if (elements.homogeneousTypeToDisplay.isPresent()) {
            key = (String)key + " (" + elements.homogeneousTypeToDisplay.get() + ")";
        }
        return key;
    }

    private static String numberString(int n, int count) {
        return count == 1 ? String.format("#%d", n) : String.format("#%s [%d copies]", n, count);
    }

    private static ElementFactGrouping pickGrouping(Map<?, Integer> first, Map<?, Integer> second) {
        boolean firstHasMultiple = IterableSubject.hasMultiple(first);
        boolean secondHasMultiple = IterableSubject.hasMultiple(second);
        if ((firstHasMultiple || secondHasMultiple) && IterableSubject.anyContainsCommaOrNewline(first, second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (firstHasMultiple && IterableSubject.containsEmptyOrLong(first)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (secondHasMultiple && IterableSubject.containsEmptyOrLong(second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        return ElementFactGrouping.ALL_IN_ONE_FACT;
    }

    private static boolean anyContainsCommaOrNewline(Map<?, Integer> ... lists) {
        for (Map<?, Integer> list : lists) {
            for (Map.Entry<?, Integer> entry : list.entrySet()) {
                String s = String.valueOf(entry.getKey());
                if (!s.contains("\n") && !s.contains(",")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasMultiple(Map<?, Integer> entries) {
        int totalCount = 0;
        for (Map.Entry<?, Integer> entry : entries.entrySet()) {
            if ((totalCount += entry.getValue().intValue()) <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEmptyOrLong(Map<?, Integer> entries) {
        int totalLength = 0;
        for (Map.Entry<?, Integer> entry : entries.entrySet()) {
            String s = SubjectUtils.entryString(entry.getKey(), entry.getValue());
            if (s.isEmpty()) {
                return true;
            }
            totalLength += s.length();
        }
        return totalLength > 200;
    }

    public final void containsNoneOf(Object firstExcluded, Object secondExcluded, Object ... restOfExcluded) {
        this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
    }

    public final void containsNoneIn(Collection<?> excluded) {
        Collection<?> actual = SubjectUtils.iterableToCollection(this.actual);
        ArrayList present = new ArrayList();
        for (Object item : new LinkedHashSet(excluded)) {
            if (!actual.contains(item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)), Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(present)), this.fullContents());
        }
    }

    public final void containsNoneIn(Object[] excluded) {
        this.containsNoneIn(Arrays.asList(excluded));
    }

    public void isInStrictOrder() {
        this.isInStrictOrder(Comparator.naturalOrder());
    }

    public final void isInStrictOrder(final Comparator<?> comparator) {
        Objects.requireNonNull(comparator);
        this.pairwiseCheck("expected to be in strict order", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) < 0;
            }
        });
    }

    public void isInOrder() {
        this.isInOrder(Comparator.naturalOrder());
    }

    public final void isInOrder(final Comparator<?> comparator) {
        Objects.requireNonNull(comparator);
        this.pairwiseCheck("expected to be in order", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) <= 0;
            }
        });
    }

    private void pairwiseCheck(String expectedFact, PairwiseChecker checker) {
        Iterator<?> iterator = this.actual.iterator();
        if (iterator.hasNext()) {
            Object prev = iterator.next();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!checker.check(prev, next)) {
                    this.failWithoutActual(Fact.simpleFact(expectedFact), Fact.fact("but contained", prev), Fact.fact("followed by", next), this.fullContents());
                    return;
                }
                prev = next;
            }
        }
    }

    @Override
    @Deprecated
    public void isNoneOf(Object first, Object second, Object ... rest) {
        super.isNoneOf(first, second, rest);
    }

    @Override
    @Deprecated
    public void isNotIn(Iterable<?> iterable) {
        boolean containsElement = StreamSupport.stream(iterable.spliterator(), false).anyMatch(obj -> Objects.equals(this.actual, obj));
        if (containsElement) {
            this.failWithActual("expected not to be any of", iterable);
        }
        ArrayList nonIterables = new ArrayList();
        for (Object element : iterable) {
            if (element instanceof Iterable) continue;
            nonIterables.add(element);
        }
        if (!nonIterables.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact(String.format("The actual value is an Iterable, and you've written a test that compares it to some objects that are not Iterables. Did you instead mean to check whether its *contents* match any of the *contents* of the given values? If so, call containsNoneOf(...)/containsNoneIn(...) instead. Non-iterables: %s", nonIterables)), new Fact[0]);
        }
    }

    private Fact fullContents() {
        return Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall());
    }

    public <A, E> UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence<A, E>(this, correspondence);
    }

    public <T> UsingCorrespondence<T, T> formattingDiffsUsing(Correspondence.DiffFormatter<? super T, ? super T> formatter) {
        return this.comparingElementsUsing(Correspondence.equality().formattingDiffsUsing(formatter));
    }

    static enum ElementFactGrouping {
        ALL_IN_ONE_FACT,
        FACT_PER_ELEMENT;

    }

    private static interface PairwiseChecker {
        public boolean check(Object var1, Object var2);
    }

    public static class UsingCorrespondence<A, E> {
        private final IterableSubject subject;
        private final Correspondence<? super A, ? super E> correspondence;
        private final Optional<Pairer> pairer;

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence) {
            this.subject = Objects.requireNonNull(subject);
            this.correspondence = Objects.requireNonNull(correspondence);
            this.pairer = Optional.empty();
        }

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence, Pairer pairer) {
            this.subject = Objects.requireNonNull(subject);
            this.correspondence = Objects.requireNonNull(correspondence);
            this.pairer = Optional.of(pairer);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super E, ?> keyFunction) {
            Function<? super E, ?> actualKeyFunction = keyFunction;
            return this.displayingDiffsPairedBy(actualKeyFunction, keyFunction);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
            return new UsingCorrespondence<A, E>(this.subject, this.correspondence, new Pairer(actualKeyFunction, expectedKeyFunction));
        }

        public void contains(E expected) {
            List keyMatches;
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, expected, exceptions)) continue;
                if (exceptions.hasCompareException()) {
                    ArrayList<Fact> facts = new ArrayList<Fact>(exceptions.describeAsMainCause());
                    facts.add(Fact.fact("expected to contain", expected));
                    facts.addAll(this.correspondence.describeForIterable());
                    facts.add(Fact.fact("found match (but failing because of exception)", actual));
                    facts.add(this.subject.fullContents());
                    this.subject.failWithoutActual(facts);
                }
                return;
            }
            if (this.pairer.isPresent() && !(keyMatches = this.pairer.get().pairOne(expected, this.getCastActual(), exceptions)).isEmpty()) {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.fact("expected to contain", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.simpleFact("but did not"));
                facts.addAll(this.formatExtras("though it did contain elements with correct key", expected, keyMatches, exceptions));
                facts.add(Fact.simpleFact("---"));
                facts.add(this.subject.fullContents());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return;
            }
            ArrayList<Fact> facts = new ArrayList<Fact>();
            facts.add(Fact.fact("expected to contain", expected));
            facts.addAll(this.correspondence.describeForIterable());
            facts.add(this.subject.butWas());
            facts.addAll(exceptions.describeAsAdditionalInfo());
            this.subject.failWithoutActual(facts);
        }

        public void doesNotContain(E excluded) {
            ArrayList<Fact> facts;
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ArrayList<A> matchingElements = new ArrayList<A>();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, excluded, exceptions)) continue;
                matchingElements.add(actual);
            }
            if (!matchingElements.isEmpty()) {
                facts = new ArrayList<Fact>();
                facts.add(Fact.fact("expected not to contain", excluded));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.fact("but contained", SubjectUtils.countDuplicates(matchingElements)));
                facts.add(this.subject.fullContents());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return;
            }
            if (exceptions.hasCompareException()) {
                facts = new ArrayList();
                facts.addAll(exceptions.describeAsMainCause());
                facts.add(Fact.fact("expected not to contain", excluded));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.simpleFact("found no match (but failing because of exception)"));
                facts.add(this.subject.fullContents());
                this.subject.failWithoutActual(facts);
            }
        }

        @SafeVarargs
        public final Ordered containsExactly(E ... expected) {
            List<Object> expectedList;
            if (expected == null) {
                expectedList = new ArrayList();
                expectedList.add(null);
            } else {
                expectedList = Arrays.asList(expected);
            }
            return this.containsExactlyElementsIn(expectedList);
        }

        public Ordered containsExactlyElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (expectedList.isEmpty()) {
                if (actualList.isEmpty()) {
                    return IN_ORDER;
                }
                this.subject.isEmpty();
                return ALREADY_FAILED;
            }
            if (this.correspondInOrderExactly(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            Map<Integer, Set<Integer>> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissingOrExtra(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            Map<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping(candidateMapping);
            if (this.failIfOneToOneMappingHasMissingOrExtra(actualList, expectedList, maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                ArrayList<Fact> facts = new ArrayList<Fact>(exceptions.describeAsMainCause());
                facts.add(Fact.fact("expected", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.simpleFact("found all expected elements (but failing because of exception)"));
                facts.add(this.subject.fullContents());
                this.subject.failWithoutActual(facts);
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    facts.add(Fact.simpleFact("contents match, but order was wrong"));
                    facts.add(Fact.fact("expected", expected));
                    facts.addAll(correspondence.describeForIterable());
                    subject.failWithActual(facts);
                }
            };
        }

        public Ordered containsExactlyElementsIn(E[] expected) {
            return this.containsExactlyElementsIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderExactly(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (actual.hasNext() && expected.hasNext()) {
                E expectedElement;
                A actualElement = actual.next();
                if (this.correspondence.safeCompare(actualElement, expectedElement = expected.next(), exceptions)) continue;
                return false;
            }
            return !actual.hasNext() && !expected.hasNext();
        }

        private Map<Integer, Set<Integer>> findCandidateMapping(List<? extends A> actual, List<? extends E> expected, Correspondence.ExceptionStore exceptions) {
            LinkedHashMap<Integer, Set<Integer>> mapping = new LinkedHashMap<Integer, Set<Integer>>();
            for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
                for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
                    if (!this.correspondence.safeCompare(actual.get(actualIndex), expected.get(expectedIndex), exceptions)) continue;
                    int expi = expectedIndex;
                    mapping.compute(actualIndex, (k, v) -> {
                        if (v == null) {
                            v = new LinkedHashSet<Integer>();
                        }
                        v.add(expi);
                        return v;
                    });
                }
            }
            return mapping;
        }

        private boolean failIfCandidateMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, Map<Integer, Set<Integer>> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, mapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            if (!missing.isEmpty() || !extra.isEmpty()) {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.addAll(this.describeMissingOrExtra(missing, extra, exceptions));
                facts.add(Fact.fact("expected", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(this.subject.butWas());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return true;
            }
            return false;
        }

        private List<Fact> describeMissingOrExtra(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = this.pairer.get().pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingOrExtraWithPairing(pairing, exceptions);
                }
                ArrayList<Fact> facts = new ArrayList<Fact>(this.describeMissingOrExtraWithoutPairing(missing, extra));
                facts.add(Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored"));
                return facts;
            }
            if (missing.size() == 1 && extra.size() >= 1) {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.fact("missing (1)", missing.get(0)));
                facts.addAll(this.formatExtras("unexpected", missing.get(0), extra, exceptions));
                facts.add(Fact.simpleFact("---"));
                return facts;
            }
            return this.describeMissingOrExtraWithoutPairing(missing, extra);
        }

        private List<Fact> describeMissingOrExtraWithoutPairing(List<? extends E> missing, List<? extends A> extra) {
            return IterableSubject.makeElementFactsForBoth("missing", missing, "unexpected", extra);
        }

        private List<Fact> describeMissingOrExtraWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<Fact> facts = new ArrayList<Fact>();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.getOrDefault(key, List.of());
                facts.add(Fact.fact("for key", key));
                facts.add(Fact.fact("missing", missing));
                facts.addAll(this.formatExtras("unexpected", missing, extras, exceptions));
                facts.add(Fact.simpleFact("---"));
            }
            if (!pairing.unpairedActualValues.isEmpty() || !pairing.unpairedExpectedValues.isEmpty()) {
                facts.add(Fact.simpleFact("elements without matching keys:"));
                facts.addAll(this.describeMissingOrExtraWithoutPairing(pairing.unpairedExpectedValues, pairing.unpairedActualValues));
            }
            return facts;
        }

        private List<Fact> formatExtras(String label, E missing, List<? extends A> extras, Correspondence.ExceptionStore exceptions) {
            ArrayList<String> diffs = new ArrayList<String>(extras.size());
            boolean hasDiffs = false;
            for (int i = 0; i < extras.size(); ++i) {
                A extra = extras.get(i);
                String diff = this.correspondence.safeFormatDiff(extra, missing, exceptions);
                diffs.add(diff);
                if (diff == null) continue;
                hasDiffs = true;
            }
            if (hasDiffs) {
                ArrayList<Fact> extraFacts = new ArrayList<Fact>();
                extraFacts.add(Fact.simpleFact(String.format("%s (%d)", label, extras.size())));
                for (int i = 0; i < extras.size(); ++i) {
                    A extra = extras.get(i);
                    extraFacts.add(Fact.fact(String.format("#%d", i + 1), extra));
                    if (diffs.get(i) == null) continue;
                    extraFacts.add(Fact.fact("diff", diffs.get(i)));
                }
                return extraFacts;
            }
            return List.of(Fact.fact(String.format("%s (%d)", label, extras.size()), SubjectUtils.countDuplicates(extras)));
        }

        private <T> List<T> findNotIndexed(List<T> list, Set<Integer> indexes) {
            if (indexes.size() == list.size()) {
                return Arrays.asList(new Object[0]);
            }
            ArrayList<T> notIndexed = new ArrayList<T>();
            for (int index = 0; index < list.size(); ++index) {
                if (indexes.contains(index)) continue;
                notIndexed.add(list.get(index));
            }
            return notIndexed;
        }

        private Map<Integer, Integer> findMaximalOneToOneMapping(Map<Integer, Set<Integer>> edges) {
            return GraphMatching.maximumCardinalityBipartiteMatching(edges);
        }

        private boolean failIfOneToOneMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, Map<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, new HashSet<Integer>(mapping.values()));
            if (!missing.isEmpty() || !extra.isEmpty()) {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.simpleFact("in an assertion requiring a 1:1 mapping between the expected and the actual elements, each actual element matches as least one expected element, and vice versa, but there was no 1:1 mapping"));
                facts.add(Fact.simpleFact("using the most complete 1:1 mapping (or one such mapping, if there is a tie)"));
                facts.addAll(this.describeMissingOrExtra(missing, extra, exceptions));
                facts.add(Fact.fact("expected", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(this.subject.butWas());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return true;
            }
            return false;
        }

        @SafeVarargs
        public final Ordered containsAtLeast(E first, E second, E ... rest) {
            return this.containsAtLeastElementsIn(SubjectUtils.accumulate(first, second, rest));
        }

        public Ordered containsAtLeastElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (this.correspondInOrderAllIn(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            Map<Integer, Set<Integer>> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissing(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            Map<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping(candidateMapping);
            if (this.failIfOneToOneMappingHasMissing(actualList, expectedList, maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                ArrayList<Fact> facts = new ArrayList<Fact>(exceptions.describeAsMainCause());
                facts.add(Fact.fact("expected to contain at least", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.simpleFact("found all expected elements (but failing because of exception)"));
                facts.add(this.subject.fullContents());
                this.subject.failWithoutActual(facts);
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    facts.add(Fact.simpleFact("required elements were all found, but order was wrong"));
                    facts.add(Fact.fact("expected order for required elements", expected));
                    facts.addAll(correspondence.describeForIterable());
                    subject.failWithActual(facts);
                }
            };
        }

        public Ordered containsAtLeastElementsIn(E[] expected) {
            return this.containsAtLeastElementsIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderAllIn(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (expected.hasNext()) {
                E expectedElement = expected.next();
                if (this.findCorresponding(actual, expectedElement, exceptions) && !exceptions.hasCompareException()) continue;
                return false;
            }
            return true;
        }

        private boolean findCorresponding(Iterator<? extends A> actual, E expectedElement, Correspondence.ExceptionStore exceptions) {
            while (actual.hasNext()) {
                A actualElement = actual.next();
                if (!this.correspondence.safeCompare(actualElement, expectedElement, exceptions)) continue;
                return true;
            }
            return false;
        }

        private boolean failIfCandidateMappingHasMissing(List<? extends A> actual, List<? extends E> expected, Map<Integer, Set<Integer>> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, mapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                ArrayList<Fact> facts = new ArrayList<Fact>(this.describeMissing(missing, extra, exceptions));
                facts.add(Fact.fact("expected to contain at least", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(this.subject.butWas());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return true;
            }
            return false;
        }

        private List<Fact> describeMissing(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = this.pairer.get().pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingWithPairing(pairing, exceptions);
                }
                ArrayList<Fact> facts = new ArrayList<Fact>(this.describeMissingWithoutPairing(missing));
                facts.add(Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored"));
                return facts;
            }
            return this.describeMissingWithoutPairing(missing);
        }

        private List<Fact> describeMissingWithoutPairing(List<? extends E> missing) {
            return IterableSubject.makeElementFactsForBoth("missing", missing, "unexpected", List.of());
        }

        private List<Fact> describeMissingWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<Fact> facts = new ArrayList<Fact>();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.getOrDefault(key, List.of());
                facts.add(Fact.fact("for key", key));
                facts.add(Fact.fact("missing", missing));
                facts.addAll(this.formatExtras("did contain elements with that key", missing, extras, exceptions));
                facts.add(Fact.simpleFact("---"));
            }
            if (!pairing.unpairedExpectedValues.isEmpty()) {
                facts.add(Fact.simpleFact("elements without matching keys:"));
                facts.addAll(this.describeMissingWithoutPairing(pairing.unpairedExpectedValues));
            }
            return facts;
        }

        private boolean failIfOneToOneMappingHasMissing(List<? extends A> actual, List<? extends E> expected, Map<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, new HashSet<Integer>(mapping.values()));
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.simpleFact("in an assertion requiring a 1:1 mapping between the expected and a subset of the actual elements, each actual element matches as least one expected element, and vice versa, but there was no 1:1 mapping"));
                facts.add(Fact.simpleFact("using the most complete 1:1 mapping (or one such mapping, if there is a tie)"));
                facts.addAll(this.describeMissing(missing, extra, exceptions));
                facts.add(Fact.fact("expected to contain at least", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(this.subject.butWas());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return true;
            }
            return false;
        }

        @SafeVarargs
        public final void containsAnyOf(E first, E second, E ... rest) {
            this.containsAnyIn(SubjectUtils.accumulate(first, second, rest));
        }

        public void containsAnyIn(Iterable<? extends E> expected) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (E expectedItem : expected) {
                for (A actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, expectedItem, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        ArrayList<Fact> facts = new ArrayList<Fact>();
                        facts.addAll(exceptions.describeAsMainCause());
                        facts.add(Fact.fact("expected to contain any of", expected));
                        facts.addAll(this.correspondence.describeForIterable());
                        facts.add(Fact.simpleFact("found match (but failing because of exception)"));
                        facts.add(this.subject.fullContents());
                        this.subject.failWithoutActual(facts);
                    }
                    return;
                }
            }
            if (this.pairer.isPresent()) {
                ArrayList<Fact> facts;
                Pairing pairing = this.pairer.get().pair(SubjectUtils.iterableToList(expected), SubjectUtils.iterableToList(actual), exceptions);
                if (pairing != null) {
                    if (!pairing.pairedKeysToExpectedValues.isEmpty()) {
                        facts = new ArrayList();
                        facts.add(Fact.fact("expected to contain any of", expected));
                        facts.addAll(this.correspondence.describeForIterable());
                        facts.add(this.subject.butWas());
                        facts.addAll(this.describeAnyMatchesByKey(pairing, exceptions));
                        facts.addAll(exceptions.describeAsAdditionalInfo());
                        this.subject.failWithoutActual(facts);
                    } else {
                        facts = new ArrayList();
                        facts.add(Fact.fact("expected to contain any of", expected));
                        facts.addAll(this.correspondence.describeForIterable());
                        facts.add(this.subject.butWas());
                        facts.add(Fact.simpleFact("it does not contain any matches by key, either"));
                        facts.addAll(exceptions.describeAsAdditionalInfo());
                        this.subject.failWithoutActual(facts);
                    }
                } else {
                    facts = new ArrayList<Fact>();
                    facts.add(Fact.fact("expected to contain any of", expected));
                    facts.addAll(this.correspondence.describeForIterable());
                    facts.add(this.subject.butWas());
                    facts.add(Fact.simpleFact("a key function which does not uniquely key the expected elements was provided and has consequently been ignored"));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    this.subject.failWithoutActual(facts);
                }
            } else {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.fact("expected to contain any of", expected));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(this.subject.butWas());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
            }
        }

        public void containsAnyIn(E[] expected) {
            this.containsAnyIn(Arrays.asList(expected));
        }

        private List<Fact> describeAnyMatchesByKey(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<Fact> facts = new ArrayList<Fact>();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object expected = pairing.pairedKeysToExpectedValues.get(key);
                List got = pairing.pairedKeysToActualValues.getOrDefault(key, List.of());
                facts.add(Fact.fact("for key", key));
                facts.add(Fact.fact("expected any of", expected));
                facts.addAll(this.formatExtras("but got", expected, got, exceptions));
                facts.add(Fact.simpleFact("---"));
            }
            return facts;
        }

        @SafeVarargs
        public final void containsNoneOf(E firstExcluded, E secondExcluded, E ... restOfExcluded) {
            this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
        }

        public void containsNoneIn(Collection<? extends E> excluded) {
            ArrayList<Fact> facts;
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            LinkedHashMap present = new LinkedHashMap();
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (Object excludedItem : new LinkedHashSet<E>(excluded)) {
                for (Object actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, excludedItem, exceptions)) continue;
                    present.compute(excludedItem, (k, v) -> {
                        if (v == null) {
                            v = new LinkedList<Object>();
                        }
                        v.add(actualItem);
                        return v;
                    });
                }
            }
            if (!present.isEmpty()) {
                facts = new ArrayList<Fact>();
                facts.add(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)));
                facts.addAll(this.correspondence.describeForIterable());
                for (Object excludedItem : present.keySet()) {
                    List actualItems = present.getOrDefault(excludedItem, List.of());
                    facts.add(Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(actualItems)));
                    facts.add(Fact.fact("corresponding to", excludedItem));
                    facts.add(Fact.simpleFact("---"));
                }
                facts.add(this.subject.fullContents());
                facts.addAll(exceptions.describeAsAdditionalInfo());
                this.subject.failWithoutActual(facts);
                return;
            }
            if (exceptions.hasCompareException()) {
                facts = new ArrayList();
                facts.addAll(exceptions.describeAsMainCause());
                facts.add(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)));
                facts.addAll(this.correspondence.describeForIterable());
                facts.add(Fact.simpleFact("found no matches (but failing because of exception)"));
                facts.add(this.subject.fullContents());
                this.subject.failWithoutActual(facts);
            }
        }

        public void containsNoneIn(E[] excluded) {
            this.containsNoneIn(Arrays.asList(excluded));
        }

        private Iterable<A> getCastActual() {
            return this.subject.actual;
        }

        private final class Pairer {
            private final Function<? super A, ?> actualKeyFunction;
            private final Function<? super E, ?> expectedKeyFunction;

            Pairer(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
                this.actualKeyFunction = actualKeyFunction;
                this.expectedKeyFunction = expectedKeyFunction;
            }

            Pairing pair(List<? extends E> expectedValues, List<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key;
                Object expected2;
                Pairing pairing = new Pairing();
                ArrayList<Object> expectedKeys = new ArrayList<Object>(expectedValues.size());
                for (Object expected2 : expectedValues) {
                    expectedKeys.add(this.expectedKey(expected2, exceptions));
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (key == null) continue;
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        return null;
                    }
                    pairing.pairedKeysToExpectedValues.put(key, expected2);
                }
                for (Object actual : actualValues) {
                    key = this.actualKey(actual, exceptions);
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        pairing.pairedKeysToActualValues.compute(key, (k, v) -> {
                            if (v == null) {
                                v = new ArrayList<Object>();
                            }
                            v.add(actual);
                            return v;
                        });
                        continue;
                    }
                    pairing.unpairedActualValues.add(actual);
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (pairing.pairedKeysToActualValues.containsKey(key)) continue;
                    pairing.unpairedExpectedValues.add(expected2);
                    pairing.pairedKeysToExpectedValues.remove(key);
                }
                return pairing;
            }

            List<A> pairOne(E expectedValue, Iterable<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key = this.expectedKey(expectedValue, exceptions);
                ArrayList matches = new ArrayList();
                if (key != null) {
                    for (Object actual : actualValues) {
                        if (!key.equals(this.actualKey(actual, exceptions))) continue;
                        matches.add(actual);
                    }
                }
                return matches;
            }

            private Object actualKey(A actual, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.actualKeyFunction.apply(actual);
                }
                catch (RuntimeException e) {
                    exceptions.addActualKeyFunctionException(Pairer.class, e, actual);
                    return null;
                }
            }

            private Object expectedKey(E expected, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.expectedKeyFunction.apply(expected);
                }
                catch (RuntimeException e) {
                    exceptions.addExpectedKeyFunctionException(Pairer.class, e, expected);
                    return null;
                }
            }
        }

        private final class Pairing {
            private final Map<Object, E> pairedKeysToExpectedValues = new LinkedHashMap();
            private final Map<Object, List<A>> pairedKeysToActualValues = new LinkedHashMap();
            private final List<E> unpairedExpectedValues = new ArrayList();
            private final List<A> unpairedActualValues = new ArrayList();

            private Pairing() {
            }
        }
    }
}

