/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Preconditions;
import java.util.ArrayList;
import java.util.List;

final class LazyMessage {
    private static final String PLACEHOLDER_ERR = "Incorrect number of args (%d) for the given placeholders (%d) in string template:\"%s\"";
    private final String format;
    private final Object[] args;

    LazyMessage(String format, Object ... args) {
        this.format = format;
        this.args = args;
        int placeholders = LazyMessage.countPlaceholders(format);
        Preconditions.checkArgument(placeholders == args.length, String.format(PLACEHOLDER_ERR, args.length, placeholders, format));
    }

    public String toString() {
        return String.format(this.format, this.args);
    }

    static int countPlaceholders(String template) {
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    static List<String> evaluateAll(List<LazyMessage> messages) {
        ArrayList<String> result = new ArrayList<String>();
        for (LazyMessage message : messages) {
            result.add(message.toString());
        }
        return result;
    }
}

