/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.Preconditions;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.common.truth.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapSubject
extends Subject {
    private final Map<?, ?> actual;
    private static final ValueTester<Object, Object> EQUALITY = new ValueTester<Object, Object>(){

        @Override
        public boolean test(Object actualValue, Object expectedValue) {
            return Objects.equals(actualValue, expectedValue);
        }
    };
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected MapSubject(FailureMetadata metadata, Map<?, ?> map) {
        super(metadata, map);
        this.actual = map;
    }

    @Override
    public final void isEqualTo(Object other) {
        if (Objects.equals(this.actual, other)) {
            return;
        }
        if (this.actual == null || !(other instanceof Map)) {
            super.isEqualTo(other);
            return;
        }
        this.containsEntriesInAnyOrder((Map)other, false);
    }

    public final void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize (%s) must be >= 0", expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public final void containsKey(Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).contains(key);
    }

    public final void doesNotContainKey(Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).doesNotContain(key);
    }

    public final void containsEntry(Object key, Object value) {
        AbstractMap.SimpleImmutableEntry<Object, Object> entry = new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
        if (!this.actual.entrySet().contains(entry)) {
            List<Object> keyList = Collections.singletonList(key);
            List<Object> valueList = Collections.singletonList(value);
            if (this.actual.containsKey(key)) {
                Object actualValue = this.actual.get(key);
                StandardSubjectBuilder check = this.check("get(%s)", key);
                if (value == null || actualValue == null) {
                    check = check.withMessage("key is present but with a different value");
                }
                check.that(actualValue).failEqualityCheckForEqualsWithoutDescription(value);
            } else if (SubjectUtils.hasMatchingToStringPair(this.actual.keySet(), keyList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.keySet(), keyList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry<?, ?> actualEntry : this.actual.entrySet()) {
                    if (!Objects.equals(actualEntry.getValue(), value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.simpleFact("but did not"), Fact.fact("though it did contain keys with that value", keys), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else if (SubjectUtils.hasMatchingToStringPair(this.actual.values(), valueList)) {
                this.failWithoutActual(Fact.fact("expected to contain entry", entry), Fact.fact("an instance of", SubjectUtils.objectToTypeName(entry)), Fact.simpleFact("but did not"), Fact.fact("though it did contain values", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.values(), valueList))), Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall()));
            } else {
                this.failWithActual("expected to contain entry", entry);
            }
        }
    }

    public final void doesNotContainEntry(Object key, Object value) {
        this.checkNoNeedToDisplayBothValues("entrySet()", new Object[0]).that(this.actual.entrySet()).doesNotContain(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
    }

    public final Ordered containsExactly() {
        return this.containsExactlyEntriesIn(Map.of());
    }

    public final Ordered containsExactly(Object k0, Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MapSubject.accumulateMap("containsExactly", k0, v0, rest));
    }

    public final Ordered containsAtLeast(Object k0, Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MapSubject.accumulateMap("containsAtLeast", k0, v0, rest));
    }

    private static Map<Object, Object> accumulateMap(String functionName, Object k0, Object v0, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", rest.length + 2);
        LinkedHashMap<Object, Object> expectedMap = new LinkedHashMap<Object, Object>();
        expectedMap.put(k0, v0);
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            if (keys.add(key)) continue;
            throw new IllegalArgumentException(String.format("Duplicate key (%s) cannot be passed to %s().", key, functionName));
        }
        return expectedMap;
    }

    public final Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            if (this.actual.isEmpty()) {
                return IN_ORDER;
            }
            this.isEmpty();
            return ALREADY_FAILED;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, false);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, false, null);
        }
        return ALREADY_FAILED;
    }

    public final Ordered containsAtLeastEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            return IN_ORDER;
        }
        boolean containsAnyOrder = this.containsEntriesInAnyOrder(expectedMap, true);
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, true, null);
        }
        return ALREADY_FAILED;
    }

    private boolean containsEntriesInAnyOrder(Map<?, ?> expectedMap, boolean allowUnexpected) {
        MapDifference<?, Object, Object> diff = MapDifference.create(this.actual, expectedMap, allowUnexpected, EQUALITY);
        if (diff.isEmpty()) {
            return true;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>(diff.describe(null));
        facts.add(Fact.simpleFact("---"));
        facts.add(Fact.fact(allowUnexpected ? "expected to contain at least" : "expected", expectedMap));
        facts.add(this.butWas());
        this.failWithoutActual(facts);
        return false;
    }

    private static String maybeAddType(Object object, boolean includeTypes) {
        return includeTypes ? String.format("%s (%s)", object, SubjectUtils.objectToTypeName(object)) : String.valueOf(object);
    }

    public final <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence<A, E>(correspondence);
    }

    public final <V> UsingCorrespondence<V, V> formattingDiffsUsing(Correspondence.DiffFormatter<? super V, ? super V> formatter) {
        return this.comparingValuesUsing(Correspondence.equality().formattingDiffsUsing(formatter));
    }

    private class MapInOrder
    implements Ordered {
        private final Map<?, ?> expectedMap;
        private final boolean allowUnexpected;
        private final Correspondence<?, ?> correspondence;

        MapInOrder(Map<?, ?> expectedMap, boolean allowUnexpected, Correspondence<?, ?> correspondence) {
            this.expectedMap = expectedMap;
            this.allowUnexpected = allowUnexpected;
            this.correspondence = correspondence;
        }

        @Override
        public void inOrder() {
            ArrayList expectedKeyOrder = new ArrayList(Util.intersection(this.expectedMap.keySet(), MapSubject.this.actual.keySet()));
            ArrayList actualKeyOrder = new ArrayList(Util.intersection(MapSubject.this.actual.keySet(), this.expectedMap.keySet()));
            if (!actualKeyOrder.equals(expectedKeyOrder)) {
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.simpleFact(this.allowUnexpected ? "required entries were all found, but order was wrong" : "entries match, but order was wrong"));
                facts.add(Fact.fact(this.allowUnexpected ? "expected to contain at least" : "expected", this.expectedMap));
                if (this.correspondence != null) {
                    facts.addAll(this.correspondence.describeForMapValues());
                }
                MapSubject.this.failWithActual(facts);
            }
        }
    }

    private static interface ValueTester<A, E> {
        public boolean test(A var1, E var2);
    }

    private static class MapDifference<K, A, E> {
        private final Map<K, E> missing;
        private final Map<K, A> unexpected;
        private final Map<K, ValueDifference<A, E>> wrongValues;
        private final Set<K> allKeys;

        static <K, A, E> MapDifference<K, A, E> create(Map<? extends K, ? extends A> actual, Map<? extends K, ? extends E> expected, boolean allowUnexpected, ValueTester<? super A, ? super E> valueTester) {
            LinkedHashMap<K, A> unexpected = new LinkedHashMap<K, A>(actual);
            LinkedHashMap<K, E> missing = new LinkedHashMap<K, E>();
            LinkedHashMap wrongValues = new LinkedHashMap();
            for (Map.Entry<K, E> expectedEntry : expected.entrySet()) {
                K expectedKey = expectedEntry.getKey();
                E expectedValue = expectedEntry.getValue();
                if (actual.containsKey(expectedKey)) {
                    Object actualValue = unexpected.remove(expectedKey);
                    if (valueTester.test(actualValue, expectedValue)) continue;
                    wrongValues.put(expectedKey, new ValueDifference(actualValue, expectedValue));
                    continue;
                }
                missing.put(expectedKey, expectedValue);
            }
            if (allowUnexpected) {
                unexpected.clear();
            }
            return new MapDifference(missing, unexpected, wrongValues, Util.union(actual.keySet(), expected.keySet()));
        }

        private MapDifference(Map<K, E> missing, Map<K, A> unexpected, Map<K, ValueDifference<A, E>> wrongValues, Set<K> allKeys) {
            this.missing = missing;
            this.unexpected = unexpected;
            this.wrongValues = wrongValues;
            this.allKeys = allKeys;
        }

        boolean isEmpty() {
            return this.missing.isEmpty() && this.unexpected.isEmpty() && this.wrongValues.isEmpty();
        }

        List<Fact> describe(Differ<? super A, ? super E> differ) {
            boolean includeKeyTypes = this.includeKeyTypes();
            ArrayList<Fact> facts = new ArrayList<Fact>();
            if (!this.wrongValues.isEmpty()) {
                facts.add(Fact.simpleFact("keys with wrong values"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.wrongValues.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.addAll(entry.getValue().describe(differ));
            }
            if (!this.missing.isEmpty()) {
                facts.add(Fact.simpleFact("missing keys"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.missing.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.add(Fact.fact("expected value", entry.getValue()));
            }
            if (!this.unexpected.isEmpty()) {
                facts.add(Fact.simpleFact("unexpected keys"));
            }
            for (Map.Entry<K, ValueDifference<A, E>> entry : this.unexpected.entrySet()) {
                facts.add(Fact.fact("for key", MapSubject.maybeAddType(entry.getKey(), includeKeyTypes)));
                facts.add(Fact.fact("unexpected value", entry.getValue()));
            }
            return facts;
        }

        private boolean includeKeyTypes() {
            HashSet<K> keys = new HashSet<K>();
            keys.addAll(this.missing.keySet());
            keys.addAll(this.unexpected.keySet());
            keys.addAll(this.wrongValues.keySet());
            return SubjectUtils.hasMatchingToStringPair(keys, this.allKeys);
        }
    }

    private static interface Differ<A, E> {
        public String diff(A var1, E var2);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = Objects.requireNonNull(correspondence);
        }

        public void containsEntry(Object expectedKey, E expectedValue) {
            if (MapSubject.this.actual.containsKey(expectedKey)) {
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(expectedKey);
                if (this.correspondence.safeCompare(actualValue, expectedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    return;
                }
                String diff = this.correspondence.safeFormatDiff(actualValue, expectedValue, exceptions);
                if (diff != null) {
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    facts.add(Fact.fact("for key", expectedKey));
                    facts.add(Fact.fact("expected value", expectedValue));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.fact("but got value", actualValue));
                    facts.add(Fact.fact("diff", diff));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    MapSubject.this.failWithoutActual(facts);
                } else {
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    facts.add(Fact.fact("for key", expectedKey));
                    facts.add(Fact.fact("expected value", expectedValue));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.fact("but got value", actualValue));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    MapSubject.this.failWithoutActual(facts);
                }
            } else {
                ArrayList<Fact> facts;
                LinkedHashSet keys = new LinkedHashSet();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry<?, A> actualEntry : this.getCastSubject().entrySet()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    facts = new ArrayList<Fact>();
                    facts.add(Fact.fact("for key", expectedKey));
                    facts.add(Fact.fact("expected value", expectedValue));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.simpleFact("but was missing"));
                    facts.add(Fact.fact("other keys with matching values", keys));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    MapSubject.this.failWithoutActual(facts);
                } else {
                    facts = new ArrayList();
                    facts.add(Fact.fact("for key", expectedKey));
                    facts.add(Fact.fact("expected value", expectedValue));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.simpleFact("but was missing"));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    MapSubject.this.failWithoutActual(facts);
                }
            }
        }

        public void doesNotContainEntry(Object excludedKey, E excludedValue) {
            if (MapSubject.this.actual.containsKey(excludedKey)) {
                ArrayList<Fact> facts;
                Correspondence.ExceptionStore exceptions;
                A actualValue = this.getCastSubject().get(excludedKey);
                if (this.correspondence.safeCompare(actualValue, excludedValue, exceptions = Correspondence.ExceptionStore.forMapValues())) {
                    facts = new ArrayList<Fact>();
                    facts.add(Fact.fact("expected not to contain", new AbstractMap.SimpleImmutableEntry<Object, E>(excludedKey, excludedValue)));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.fact("but contained", new AbstractMap.SimpleImmutableEntry<Object, A>(excludedKey, actualValue)));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    facts.addAll(exceptions.describeAsAdditionalInfo());
                    MapSubject.this.failWithoutActual(facts);
                }
                if (exceptions.hasCompareException()) {
                    facts = new ArrayList();
                    facts.addAll(exceptions.describeAsMainCause());
                    facts.add(Fact.fact("expected not to contain", new AbstractMap.SimpleImmutableEntry<Object, E>(excludedKey, excludedValue)));
                    facts.addAll(this.correspondence.describeForMapValues());
                    facts.add(Fact.simpleFact("found no match (but failing because of exception)"));
                    facts.add(Fact.fact("full map", MapSubject.this.actualCustomStringRepresentationForPackageMembersToCall()));
                    MapSubject.this.failWithoutActual(facts);
                }
            }
        }

        public Ordered containsExactly(Object k0, E v0, Object ... rest) {
            Map<Object, Object> expectedMap = MapSubject.accumulateMap("containsExactly", k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMap);
        }

        public Ordered containsAtLeast(Object k0, E v0, Object ... rest) {
            Map<Object, Object> expectedMap = MapSubject.accumulateMap("containsAtLeast", k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMap);
        }

        public Ordered containsExactlyEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                if (MapSubject.this.actual.isEmpty()) {
                    return IN_ORDER;
                }
                MapSubject.this.isEmpty();
                return ALREADY_FAILED;
            }
            return this.internalContainsEntriesIn(expectedMap, false);
        }

        public Ordered containsAtLeastEntriesIn(Map<?, ? extends E> expectedMap) {
            if (expectedMap.isEmpty()) {
                return IN_ORDER;
            }
            return this.internalContainsEntriesIn(expectedMap, true);
        }

        private <K, V extends E> Ordered internalContainsEntriesIn(Map<K, V> expectedMap, boolean allowUnexpected) {
            final Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
            MapDifference<?, A, V> diff = MapDifference.create(this.getCastSubject(), expectedMap, allowUnexpected, new ValueTester<A, E>(){

                @Override
                public boolean test(A actualValue, E expectedValue) {
                    return UsingCorrespondence.this.correspondence.safeCompare(actualValue, expectedValue, exceptions);
                }
            });
            if (diff.isEmpty()) {
                return new MapInOrder(expectedMap, allowUnexpected, this.correspondence);
            }
            ArrayList<Fact> facts = new ArrayList<Fact>(diff.describe(this.differ(exceptions)));
            facts.add(Fact.simpleFact("---"));
            facts.add(Fact.fact(allowUnexpected ? "expected to contain at least" : "expected", expectedMap));
            facts.addAll(this.correspondence.describeForMapValues());
            facts.add(MapSubject.this.butWas());
            facts.addAll(exceptions.describeAsAdditionalInfo());
            MapSubject.this.failWithoutActual(facts);
            return ALREADY_FAILED;
        }

        private <V extends E> Differ<A, V> differ(final Correspondence.ExceptionStore exceptions) {
            return new Differ<A, V>(){

                @Override
                public String diff(A actual, V expected) {
                    return UsingCorrespondence.this.correspondence.safeFormatDiff(actual, expected, exceptions);
                }
            };
        }

        private Map<?, A> getCastSubject() {
            return MapSubject.this.actual;
        }
    }

    private static class ValueDifference<A, E> {
        private final A actual;
        private final E expected;

        ValueDifference(A actual, E expected) {
            this.actual = actual;
            this.expected = expected;
        }

        List<Fact> describe(Differ<? super A, ? super E> differ) {
            String diffString;
            boolean includeTypes = differ == null && String.valueOf(this.actual).equals(String.valueOf(this.expected));
            ArrayList<Fact> facts = new ArrayList<Fact>();
            facts.add(Fact.fact("expected value", MapSubject.maybeAddType(this.expected, includeTypes)));
            facts.add(Fact.fact("but got value", MapSubject.maybeAddType(this.actual, includeTypes)));
            if (differ != null && (diffString = differ.diff(this.actual, this.expected)) != null) {
                facts.add(Fact.fact("diff", diffString));
            }
            return facts;
        }
    }
}

