/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

final class MathUtil {
    private MathUtil() {
    }

    public static boolean equalWithinTolerance(double left, double right, double tolerance) {
        return Math.abs(left - right) <= Math.abs(tolerance);
    }

    public static boolean equalWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.equalWithinTolerance((double)left, (double)right, (double)tolerance);
    }

    public static boolean notEqualWithinTolerance(double left, double right, double tolerance) {
        if (MathUtil.isFinite(left) && MathUtil.isFinite(right)) {
            return Math.abs(left - right) > Math.abs(tolerance);
        }
        return false;
    }

    private static boolean isFinite(double value) {
        return Double.NEGATIVE_INFINITY < value && value < Double.POSITIVE_INFINITY;
    }

    public static boolean notEqualWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.notEqualWithinTolerance((double)left, (double)right, (double)tolerance);
    }
}

