/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.LazyMessage;
import com.google.common.truth.Platform;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.SubjectUtils;
import com.google.common.truth.Util;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Subject {
    private static final FailureStrategy IGNORE_STRATEGY = new FailureStrategy(){

        @Override
        public void fail(AssertionError failure) {
        }
    };
    private final FailureMetadata metadata;
    private final Object actual;
    private String customName = null;
    private final String typeDescriptionOverride;
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();
    private static final Function<Object, Object> STRINGIFY = new Function<Object, Object>(){

        @Override
        public Object apply(Object input) {
            if (input != null && input.getClass().isArray()) {
                List<Object> iterable = input.getClass() == boolean[].class ? Util.booleansAsList((boolean[])input) : (input.getClass() == int[].class ? Util.intsAsList((int[])input) : (input.getClass() == long[].class ? Util.longsAsList((long[])input) : (input.getClass() == short[].class ? Util.shortsAsList((short[])input) : (input.getClass() == byte[].class ? Util.bytesAsList((byte[])input) : (input.getClass() == double[].class ? Subject.doubleArrayAsString((double[])input) : (input.getClass() == float[].class ? Subject.floatArrayAsString((float[])input) : (input.getClass() == char[].class ? Util.charsAsList((char[])input) : Arrays.asList((Object[])input))))))));
                return StreamSupport.stream(iterable.spliterator(), false).map(STRINGIFY).collect(Collectors.toList());
            }
            return input;
        }
    };
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    protected Subject(FailureMetadata metadata, Object actual) {
        this(metadata, actual, null);
    }

    Subject(FailureMetadata metadata, Object actual, String typeDescriptionOverride) {
        this.metadata = metadata.updateForSubject(this);
        this.actual = actual;
        this.typeDescriptionOverride = typeDescriptionOverride;
    }

    public void isNull() {
        this.standardIsEqualTo(null);
    }

    public void isNotNull() {
        this.standardIsNotEqualTo(null);
    }

    public void isEqualTo(Object expected) {
        this.standardIsEqualTo(expected);
    }

    private void standardIsEqualTo(Object expected) {
        ComparisonResult difference = this.compareForEquality(expected);
        if (!difference.valuesAreEqual()) {
            this.failEqualityCheck(EqualityCheck.EQUAL, expected, difference);
        }
    }

    public void isNotEqualTo(Object unexpected) {
        this.standardIsNotEqualTo(unexpected);
    }

    private void standardIsNotEqualTo(Object unexpected) {
        ComparisonResult difference = this.compareForEquality(unexpected);
        if (difference.valuesAreEqual()) {
            String unexpectedAsString = this.formatActualOrExpected(unexpected);
            if (this.actualCustomStringRepresentation().equals(unexpectedAsString)) {
                this.failWithoutActual(Fact.fact("expected not to be", unexpectedAsString), new Fact[0]);
            } else {
                this.failWithoutActual(Fact.fact("expected not to be", unexpectedAsString), Fact.fact("but was; string representation of actual value", this.actualCustomStringRepresentation()));
            }
        }
    }

    private ComparisonResult compareForEquality(Object expected) {
        if (this.actual == null && expected == null) {
            return ComparisonResult.equal();
        }
        if (this.actual == null || expected == null) {
            return ComparisonResult.differentNoDescription();
        }
        if (this.actual instanceof byte[] && expected instanceof byte[]) {
            return Subject.checkByteArrayEquals((byte[])expected, (byte[])this.actual);
        }
        if (this.actual.getClass().isArray() && expected.getClass().isArray()) {
            return Subject.checkArrayEqualsRecursive(expected, this.actual, "");
        }
        if (Subject.isIntegralBoxedPrimitive(this.actual) && Subject.isIntegralBoxedPrimitive(expected)) {
            return ComparisonResult.fromEqualsResult(Subject.integralValue(this.actual) == Subject.integralValue(expected));
        }
        if (this.actual instanceof Double && expected instanceof Double) {
            return ComparisonResult.fromEqualsResult(Double.compare((Double)this.actual, (Double)expected) == 0);
        }
        if (this.actual instanceof Float && expected instanceof Float) {
            return ComparisonResult.fromEqualsResult(Float.compare(((Float)this.actual).floatValue(), ((Float)expected).floatValue()) == 0);
        }
        if (this.actual instanceof Double && expected instanceof Integer) {
            return ComparisonResult.fromEqualsResult(Double.compare((Double)this.actual, ((Integer)expected).intValue()) == 0);
        }
        if (this.actual instanceof Float && expected instanceof Integer) {
            return ComparisonResult.fromEqualsResult(Double.compare(((Float)this.actual).floatValue(), ((Integer)expected).intValue()) == 0);
        }
        return ComparisonResult.fromEqualsResult(this.actual == expected || this.actual.equals(expected));
    }

    private static boolean isIntegralBoxedPrimitive(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Integer || o instanceof Long;
    }

    private static long integralValue(Object o) {
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new AssertionError((Object)(o + " must be either a Character or a Number."));
    }

    public final void isSameInstanceAs(Object expected) {
        if (this.actual != expected) {
            this.failEqualityCheck(EqualityCheck.SAME_INSTANCE, expected, this.compareForEquality(expected).withoutDescription());
        }
    }

    public final void isNotSameInstanceAs(Object unexpected) {
        if (this.actual == unexpected) {
            this.failWithoutActual(Fact.fact("expected not to be specific instance", this.actualCustomStringRepresentation()), new Fact[0]);
        }
    }

    public void isInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (this.actual == null) {
            this.failWithActual("expected instance of", clazz.getName());
            return;
        }
        if (!Platform.isInstanceOfType(this.actual, clazz)) {
            if (Subject.classMetadataUnsupported()) {
                throw new UnsupportedOperationException(this.actualCustomStringRepresentation() + ", an instance of " + this.actual.getClass().getName() + ", may or may not be an instance of " + clazz.getName() + ". Under -XdisableClassMetadata, we do not have enough information to tell.");
            }
            this.failWithoutActual(Fact.fact("expected instance of", clazz.getName()), Fact.fact("but was instance of", this.actual.getClass().getName()), Fact.fact("with value", this.actualCustomStringRepresentation()));
        }
    }

    public void isNotInstanceOf(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (Subject.classMetadataUnsupported()) {
            throw new UnsupportedOperationException("isNotInstanceOf is not supported under -XdisableClassMetadata");
        }
        if (this.actual == null) {
            return;
        }
        if (Platform.isInstanceOfType(this.actual, clazz)) {
            this.failWithActual("expected not to be an instance of", clazz.getName());
        }
    }

    public void isIn(Iterable<?> iterable) {
        boolean notFound = StreamSupport.stream(iterable.spliterator(), false).noneMatch(e -> Objects.equals(this.actual, e));
        if (notFound) {
            this.failWithActual("expected any of", iterable);
        }
    }

    public void isAnyOf(Object first, Object second, Object ... rest) {
        this.isIn(SubjectUtils.accumulate(first, second, rest));
    }

    public void isNotIn(Iterable<?> iterable) {
        boolean found = StreamSupport.stream(iterable.spliterator(), false).anyMatch(e -> Objects.equals(this.actual, e));
        if (found) {
            this.failWithActual("expected not to be any of", iterable);
        }
    }

    public void isNoneOf(Object first, Object second, Object ... rest) {
        this.isNotIn(SubjectUtils.accumulate(first, second, rest));
    }

    final Object actual() {
        return this.actual;
    }

    protected String actualCustomStringRepresentation() {
        return this.formatActualOrExpected(this.actual);
    }

    final String actualCustomStringRepresentationForPackageMembersToCall() {
        return this.actualCustomStringRepresentation();
    }

    private String formatActualOrExpected(Object o) {
        if (o instanceof byte[]) {
            return Subject.base16((byte[])o);
        }
        if (o != null && o.getClass().isArray()) {
            String wrapped = StreamSupport.stream(Subject.stringableIterable(new Object[]{o}).spliterator(), false).map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
            return wrapped.substring(1, wrapped.length() - 1);
        }
        if (o instanceof Double) {
            return Platform.doubleToString((Double)o);
        }
        if (o instanceof Float) {
            return Platform.floatToString(((Float)o).floatValue());
        }
        return Platform.stringValueOfNonFloatingPoint(o);
    }

    private static String base16(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
        }
        return sb.toString();
    }

    private static Iterable<?> stringableIterable(Object[] array) {
        return Stream.of(array).map(STRINGIFY).collect(Collectors.toList());
    }

    private static ComparisonResult checkByteArrayEquals(byte[] expected, byte[] actual) {
        if (Arrays.equals(expected, actual)) {
            return ComparisonResult.equal();
        }
        return ComparisonResult.differentWithDescription(Fact.fact("expected", Arrays.toString(expected)), Fact.fact("but was", Arrays.toString(actual)));
    }

    private static ComparisonResult checkArrayEqualsRecursive(Object expectedArray, Object actualArray, String lastIndex) {
        String actualType;
        if (expectedArray == actualArray) {
            return ComparisonResult.equal();
        }
        String expectedType = Subject.arrayType(expectedArray);
        if (!expectedType.equals(actualType = Subject.arrayType(actualArray))) {
            Fact indexFact = lastIndex.isEmpty() ? Fact.simpleFact("wrong type") : Fact.fact("wrong type for index", lastIndex);
            return ComparisonResult.differentWithDescription(indexFact, Fact.fact("expected", expectedType), Fact.fact("but was", actualType));
        }
        int actualLength = Array.getLength(actualArray);
        int expectedLength = Array.getLength(expectedArray);
        if (expectedLength != actualLength) {
            Fact indexFact = lastIndex.isEmpty() ? Fact.simpleFact("wrong length") : Fact.fact("wrong length for index", lastIndex);
            return ComparisonResult.differentWithDescription(indexFact, Fact.fact("expected", expectedLength), Fact.fact("but was", actualLength));
        }
        for (int i = 0; i < actualLength; ++i) {
            String index = lastIndex + "[" + i + "]";
            Object expected = Array.get(expectedArray, i);
            Object actual = Array.get(actualArray, i);
            if (actual != null && actual.getClass().isArray() && expected != null && expected.getClass().isArray()) {
                ComparisonResult result = Subject.checkArrayEqualsRecursive(expected, actual, index);
                if (result.valuesAreEqual()) continue;
                return result;
            }
            if (Subject.gwtSafeObjectEquals(actual, expected)) continue;
            return ComparisonResult.differentWithDescription(Fact.fact("differs at index", index));
        }
        return ComparisonResult.equal();
    }

    private static String arrayType(Object array) {
        if (array.getClass() == boolean[].class) {
            return "boolean[]";
        }
        if (array.getClass() == int[].class) {
            return "int[]";
        }
        if (array.getClass() == long[].class) {
            return "long[]";
        }
        if (array.getClass() == short[].class) {
            return "short[]";
        }
        if (array.getClass() == byte[].class) {
            return "byte[]";
        }
        if (array.getClass() == double[].class) {
            return "double[]";
        }
        if (array.getClass() == float[].class) {
            return "float[]";
        }
        if (array.getClass() == char[].class) {
            return "char[]";
        }
        return "Object[]";
    }

    private static boolean gwtSafeObjectEquals(Object actual, Object expected) {
        if (actual instanceof Double && expected instanceof Double) {
            return Double.doubleToLongBits((Double)actual) == Double.doubleToLongBits((Double)expected);
        }
        if (actual instanceof Float && expected instanceof Float) {
            return Float.floatToIntBits(((Float)actual).floatValue()) == Float.floatToIntBits(((Float)expected).floatValue());
        }
        return Objects.equals(actual, expected);
    }

    private static List<String> doubleArrayAsString(double[] items) {
        ArrayList<String> itemAsStrings = new ArrayList<String>(items.length);
        for (double item : items) {
            itemAsStrings.add(Platform.doubleToString(item));
        }
        return itemAsStrings;
    }

    private static List<String> floatArrayAsString(float[] items) {
        ArrayList<String> itemAsStrings = new ArrayList<String>(items.length);
        for (float item : items) {
            itemAsStrings.add(Platform.floatToString(item));
        }
        return itemAsStrings;
    }

    @Deprecated
    final StandardSubjectBuilder check() {
        return new StandardSubjectBuilder(this.metadata.updateForCheckCall());
    }

    protected final StandardSubjectBuilder check(String format, Object ... args) {
        return this.doCheck(FailureMetadata.OldAndNewValuesAreSimilar.DIFFERENT, format, args);
    }

    final StandardSubjectBuilder checkNoNeedToDisplayBothValues(String format, Object ... args) {
        return this.doCheck(FailureMetadata.OldAndNewValuesAreSimilar.SIMILAR, format, args);
    }

    private StandardSubjectBuilder doCheck(FailureMetadata.OldAndNewValuesAreSimilar valuesAreSimilar, String format, Object[] args) {
        final LazyMessage message = new LazyMessage(format, args);
        Function<String, String> descriptionUpdate = new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input + "." + message;
            }
        };
        return new StandardSubjectBuilder(this.metadata.updateForCheckCall(valuesAreSimilar, descriptionUpdate));
    }

    protected final StandardSubjectBuilder ignoreCheck() {
        return StandardSubjectBuilder.forCustomFailureStrategy(IGNORE_STRATEGY);
    }

    protected final void failWithActual(String key, Object value) {
        this.failWithActual(Fact.fact(key, value), new Fact[0]);
    }

    protected final void failWithActual(Fact first, Fact ... rest) {
        this.doFail(SubjectUtils.sandwich(first, rest, this.butWas()));
    }

    final void failWithActual(Iterable<Fact> facts) {
        this.doFail(SubjectUtils.append(Util.iterableToList(facts), this.butWas()));
    }

    @Deprecated
    final void fail(String check) {
        this.fail(check, new Object[0]);
    }

    @Deprecated
    final void fail(String verb, Object other) {
        this.fail(verb, new Object[]{other});
    }

    @Deprecated
    final void fail(String verb, Object ... messageParts) {
        StringBuilder message = new StringBuilder("Not true that <");
        message.append(this.actualCustomStringRepresentation()).append("> ").append(verb);
        for (Object part : messageParts) {
            message.append(" <").append(part).append(">");
        }
        this.failWithoutActual(Fact.simpleFact(message.toString()), new Fact[0]);
    }

    final void failEqualityCheckForEqualsWithoutDescription(Object expected) {
        this.failEqualityCheck(EqualityCheck.EQUAL, expected, ComparisonResult.differentNoDescription());
    }

    private void failEqualityCheck(EqualityCheck equalityCheck, Object expected, ComparisonResult difference) {
        String actualString = this.actualCustomStringRepresentation();
        String expectedString = this.formatActualOrExpected(expected);
        String actualClass = this.actual == null ? "(null reference)" : this.actual.getClass().getName();
        String expectedClass = expected == null ? "(null reference)" : expected.getClass().getName();
        boolean sameToStrings = actualString.equals(expectedString);
        boolean sameClassNames = actualClass.equals(expectedClass);
        boolean equal = difference.valuesAreEqual();
        if (equalityCheck == EqualityCheck.EQUAL && (this.tryFailForTrailingWhitespaceOnly(expected) || this.tryFailForEmptyString(expected))) {
            return;
        }
        if (sameToStrings) {
            if (sameClassNames) {
                String doppelgangerDescription = equal ? "(different but equal instance of same class with same string representation)" : "(non-equal instance of same class with same string representation)";
                this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("but was", doppelgangerDescription));
            } else {
                this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("an instance of", expectedClass), Fact.fact("but was", "(non-equal value with same string representation)"), Fact.fact("an instance of", actualClass));
            }
        } else if (equalityCheck == EqualityCheck.EQUAL && this.actual != null && expected != null) {
            this.metadata.failEqualityCheck(this.nameAsFacts(), difference.factsOrEmpty(), expectedString, actualString);
        } else {
            this.failEqualityCheckNoComparisonFailure(difference, Fact.fact(equalityCheck.keyForExpected, expectedString), Fact.fact("but was", actualString));
        }
    }

    private boolean tryFailForTrailingWhitespaceOnly(Object expected) {
        if (!(this.actual instanceof String) || !(expected instanceof String)) {
            return false;
        }
        String actualString = (String)this.actual;
        String expectedString = (String)expected;
        String actualNoTrailing = actualString.stripTrailing();
        String expectedNoTrailing = expectedString.stripTrailing();
        String expectedTrailing = Subject.escapeWhitespace(expectedString.substring(expectedNoTrailing.length()));
        String actualTrailing = Subject.escapeWhitespace(actualString.substring(actualNoTrailing.length()));
        if (!actualNoTrailing.equals(expectedNoTrailing)) {
            return false;
        }
        if (actualString.startsWith(expectedString)) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("but contained extra trailing whitespace", actualTrailing));
        } else if (expectedString.startsWith(actualString)) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("but was missing trailing whitespace", expectedTrailing));
        } else {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.fact("with trailing whitespace", expectedTrailing), Fact.fact("but trailing whitespace was", actualTrailing));
        }
        return true;
    }

    private static String escapeWhitespace(String in) {
        StringBuilder out = new StringBuilder();
        for (char c : in.toCharArray()) {
            out.append(Subject.escapeWhitespace(c));
        }
        return out.toString();
    }

    private static String escapeWhitespace(char c) {
        switch (c) {
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case ' ': {
                return "\u2423";
            }
        }
        return new String(Subject.asUnicodeHexEscape(c));
    }

    private boolean tryFailForEmptyString(Object expected) {
        if (!(this.actual instanceof String) || !(expected instanceof String)) {
            return false;
        }
        String actualString = (String)this.actual;
        String expectedString = (String)expected;
        if (actualString.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected", expectedString), Fact.simpleFact("but was an empty string"));
            return true;
        }
        if (expectedString.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected an empty string"), Fact.fact("but was", actualString));
            return true;
        }
        return false;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private void failEqualityCheckNoComparisonFailure(ComparisonResult difference, Fact ... facts) {
        this.doFail(SubjectUtils.concat(Arrays.asList(facts), difference.factsOrEmpty()));
    }

    @Deprecated
    final void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = String.format("Not true that <%s> %s <%s>. It %s <%s>", this.actualCustomStringRepresentation(), verb, expected, failVerb, actual == null ? "null reference" : actual);
        this.failWithoutActual(Fact.simpleFact(message), new Fact[0]);
    }

    @Deprecated
    final void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = String.format("Not true that <%s> %s <%s>", actual == null ? "null reference" : actual, verb, expected);
        this.failWithoutActual(Fact.simpleFact(message), new Fact[0]);
    }

    @Deprecated
    final void failWithoutSubject(String check) {
        String strSubject = this.customName == null ? "the subject" : "\"" + this.customName + "\"";
        this.failWithoutActual(Fact.simpleFact(String.format("Not true that %s %s", strSubject, check)), new Fact[0]);
    }

    protected final void failWithoutActual(Fact first, Fact ... rest) {
        ArrayList<Fact> facts = new ArrayList<Fact>(1 + rest.length);
        facts.add(first);
        Collections.addAll(facts, rest);
        this.doFail(facts);
    }

    final void failWithoutActual(Iterable<Fact> facts) {
        this.doFail(Util.iterableToList(facts));
    }

    @Deprecated
    final void failWithoutActual(String check) {
        this.failWithoutSubject(check);
    }

    @Deprecated
    public final boolean equals(Object o) {
        throw new UnsupportedOperationException("Subject.equals() is not supported. Did you mean to call assertThat(actual).isEqualTo(expected) instead of assertThat(actual).equals(expected)?");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
    }

    @Deprecated
    public String toString() {
        throw new UnsupportedOperationException("Subject.toString() is not supported. Did you mean to call assertThat(foo.toString()) instead of assertThat(foo).toString()?");
    }

    final Fact butWas() {
        return Fact.fact("but was", this.actualCustomStringRepresentation());
    }

    final String typeDescription() {
        return Subject.typeDescriptionOrGuess(this.getClass(), this.typeDescriptionOverride);
    }

    private static String typeDescriptionOrGuess(Class<? extends Subject> clazz, String typeDescriptionOverride) {
        if (typeDescriptionOverride != null) {
            return typeDescriptionOverride;
        }
        String subjectClass = clazz.getSimpleName().replaceFirst(".*[$]", "");
        String actualClass = subjectClass.endsWith("Subject") && !subjectClass.equals("Subject") ? subjectClass.substring(0, subjectClass.length() - "Subject".length()) : "Object";
        return actualClass.substring(0, 1).toLowerCase(Locale.ROOT) + actualClass.substring(1);
    }

    private static boolean classMetadataUnsupported() {
        return String.class.getSuperclass() == null;
    }

    private void doFail(List<Fact> facts) {
        this.metadata.fail(this.prependNameIfAny(facts));
    }

    private List<Fact> prependNameIfAny(List<Fact> facts) {
        return SubjectUtils.concat(this.nameAsFacts(), facts);
    }

    private List<Fact> nameAsFacts() {
        return this.customName == null ? List.of() : List.of(Fact.fact("name", this.customName));
    }

    private static final class ComparisonResult {
        private static final ComparisonResult EQUAL = new ComparisonResult(null);
        private static final ComparisonResult DIFFERENT_NO_DESCRIPTION = new ComparisonResult(List.of());
        private final List<Fact> facts;

        static ComparisonResult fromEqualsResult(boolean equal) {
            return equal ? EQUAL : DIFFERENT_NO_DESCRIPTION;
        }

        static ComparisonResult differentWithDescription(Fact ... facts) {
            return new ComparisonResult(Arrays.asList(facts));
        }

        static ComparisonResult equal() {
            return EQUAL;
        }

        static ComparisonResult differentNoDescription() {
            return DIFFERENT_NO_DESCRIPTION;
        }

        private ComparisonResult(List<Fact> facts) {
            this.facts = facts;
        }

        boolean valuesAreEqual() {
            return this.facts == null;
        }

        List<Fact> factsOrEmpty() {
            return this.facts != null ? this.facts : List.of();
        }

        ComparisonResult withoutDescription() {
            return ComparisonResult.fromEqualsResult(this.valuesAreEqual());
        }
    }

    static enum EqualityCheck {
        EQUAL("expected"),
        SAME_INSTANCE("expected specific instance");

        final String keyForExpected;

        private EqualityCheck(String keyForExpected) {
            this.keyForExpected = keyForExpected;
        }
    }

    public static interface Factory<SubjectT extends Subject, ActualT> {
        public SubjectT createSubject(FailureMetadata var1, ActualT var2);
    }
}

