/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;

final class SubjectUtils {
    static final String HUMAN_UNDERSTANDABLE_EMPTY_STRING = "\"\" (empty String)";

    private SubjectUtils() {
    }

    static <T> List<T> accumulate(T first, T second, T ... rest) {
        ArrayList<T> items = new ArrayList<T>(2 + (rest == null ? 1 : rest.length));
        items.add(first);
        items.add(second);
        if (rest == null) {
            items.add(null);
        } else {
            items.addAll(Arrays.asList(rest));
        }
        return items;
    }

    static String countDuplicates(Iterable<?> items) {
        return SubjectUtils.toStringWithBrackets(SubjectUtils.countDuplicatesToMultiset(items));
    }

    static String entryString(Object element, int count) {
        String item = String.valueOf(element);
        return count > 1 ? item + " [" + count + " copies]" : item;
    }

    private static <T> Map<T, Integer> countDuplicatesToMultiset(Iterable<T> items) {
        LinkedHashMap<T, Integer> multiset = new LinkedHashMap<T, Integer>();
        for (T item : items) {
            Integer count = multiset.getOrDefault(item, 0);
            multiset.put(item, count + 1);
        }
        return multiset;
    }

    static String countDuplicatesAndAddTypeInfo(Iterable<?> itemsIterable) {
        Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
        Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
        return homogeneousTypeName.isPresent() ? String.format("%s (%s)", SubjectUtils.countDuplicates(items), homogeneousTypeName.get()) : SubjectUtils.countDuplicates(SubjectUtils.addTypeInfoToEveryItem(items));
    }

    static DuplicateGroupedAndTyped countDuplicatesAndMaybeAddTypeInfoReturnObject(Iterable<?> itemsIterable, boolean addTypeInfo) {
        if (addTypeInfo) {
            Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
            Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
            Map<Object, Integer> valuesWithCountsAndMaybeTypes = homogeneousTypeName.isPresent() ? SubjectUtils.countDuplicatesToMultiset(items) : SubjectUtils.countDuplicatesToMultiset(SubjectUtils.addTypeInfoToEveryItem(items));
            return new DuplicateGroupedAndTyped(valuesWithCountsAndMaybeTypes, homogeneousTypeName);
        }
        return new DuplicateGroupedAndTyped(SubjectUtils.countDuplicatesToMultiset(itemsIterable), Optional.empty());
    }

    static String toStringWithBrackets(Map<?, Integer> multiset) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<?, Integer> entry : multiset.entrySet()) {
            parts.add(SubjectUtils.entryString(entry.getKey(), entry.getValue()));
        }
        return ((Object)parts).toString();
    }

    static String toStringWithoutBrackets(Map<?, Integer> multiset) {
        String string = SubjectUtils.toStringWithBrackets(multiset);
        return string.substring(1, string.length() - 1);
    }

    static List<Object> retainMatchingToString(Iterable<?> items, Iterable<?> itemsToCheck) {
        LinkedHashMap stringValueToItemsToCheck = new LinkedHashMap();
        for (Object itemToCheck : itemsToCheck) {
            stringValueToItemsToCheck.compute(String.valueOf(itemToCheck), (k, v) -> {
                if (v == null) {
                    v = new LinkedHashSet<Object>();
                }
                v.add(itemToCheck);
                return v;
            });
        }
        ArrayList<Object> result = new ArrayList<Object>();
        block1: for (Object item : items) {
            for (Object itemToCheck : stringValueToItemsToCheck.getOrDefault(String.valueOf(item), Set.of())) {
                if (Objects.equals(itemToCheck, item)) continue;
                result.add(item);
                continue block1;
            }
        }
        return result;
    }

    static boolean hasMatchingToStringPair(Iterable<?> items1, Iterable<?> items2) {
        if (!items1.iterator().hasNext() || !items2.iterator().hasNext()) {
            return false;
        }
        return !SubjectUtils.retainMatchingToString(items1, items2).isEmpty();
    }

    static String objectToTypeName(Object item) {
        if (item == null) {
            return "null type";
        }
        if (item instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)item;
            String valueTypeName = entry.getValue() == entry ? "Map.Entry" : SubjectUtils.objectToTypeName(entry.getValue());
            return String.format("Map.Entry<%s, %s>", SubjectUtils.objectToTypeName(entry.getKey()), valueTypeName);
        }
        return item.getClass().getName();
    }

    private static Optional<String> getHomogeneousTypeName(Iterable<?> items) {
        Optional<String> homogeneousTypeName = Optional.empty();
        for (Object item : items) {
            if (item == null) {
                return Optional.empty();
            }
            if (!homogeneousTypeName.isPresent()) {
                homogeneousTypeName = Optional.of(SubjectUtils.objectToTypeName(item));
                continue;
            }
            if (SubjectUtils.objectToTypeName(item).equals(homogeneousTypeName.get())) continue;
            return Optional.empty();
        }
        return homogeneousTypeName;
    }

    private static List<String> addTypeInfoToEveryItem(Iterable<?> items) {
        ArrayList<String> itemsWithTypeInfo = new ArrayList<String>();
        for (Object item : items) {
            itemsWithTypeInfo.add(String.format("%s (%s)", item, SubjectUtils.objectToTypeName(item)));
        }
        return itemsWithTypeInfo;
    }

    static <T> Collection<T> iterableToCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    static <T> List<T> iterableToList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    static <T> Iterable<T> annotateEmptyStrings(Iterable<T> items) {
        boolean containsEmptyString = StreamSupport.stream(items.spliterator(), false).anyMatch(""::equals);
        if (containsEmptyString) {
            ArrayList<String> annotatedItems = new ArrayList<String>();
            for (T item : items) {
                if (Objects.equals(item, "")) {
                    String newItem = HUMAN_UNDERSTANDABLE_EMPTY_STRING;
                    annotatedItems.add(newItem);
                    continue;
                }
                annotatedItems.add((String)item);
            }
            return annotatedItems;
        }
        return items;
    }

    @SafeVarargs
    static <E> List<E> concat(Iterable<? extends E> ... inputs) {
        ArrayList result = new ArrayList();
        for (Iterable<E> iterable : inputs) {
            iterable.forEach(result::add);
        }
        return result;
    }

    static <E> List<E> append(E[] array, E object) {
        ArrayList<E> result = new ArrayList<E>();
        Collections.addAll(result, array);
        result.add(object);
        return result;
    }

    static <E> List<E> append(List<? extends E> list, E object) {
        ArrayList<E> result = new ArrayList<E>(list);
        result.add(object);
        return result;
    }

    static <E> List<E> sandwich(E first, E[] array, E last) {
        ArrayList<E> result = new ArrayList<E>();
        result.add(first);
        Collections.addAll(result, array);
        result.add(last);
        return result;
    }

    static final class DuplicateGroupedAndTyped {
        final Map<?, Integer> valuesAndMaybeTypes;
        final Optional<String> homogeneousTypeToDisplay;

        DuplicateGroupedAndTyped(Map<?, Integer> valuesAndMaybeTypes, Optional<String> homogeneousTypeToDisplay) {
            this.valuesAndMaybeTypes = valuesAndMaybeTypes;
            this.homogeneousTypeToDisplay = homogeneousTypeToDisplay;
        }

        int totalCopies() {
            return this.valuesAndMaybeTypes.values().stream().mapToInt(i -> i).sum();
        }

        boolean isEmpty() {
            return this.valuesAndMaybeTypes.isEmpty();
        }

        Map<?, Integer> entrySet() {
            return this.valuesAndMaybeTypes;
        }

        public String toString() {
            return this.homogeneousTypeToDisplay.isPresent() ? SubjectUtils.toStringWithoutBrackets(this.valuesAndMaybeTypes) + " (" + this.homogeneousTypeToDisplay.get() + ")" : SubjectUtils.toStringWithoutBrackets(this.valuesAndMaybeTypes);
        }
    }
}

