/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.truth.Truth8;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Truth {
    private static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void fail(AssertionError failure) {
            throw failure;
        }
    };
    private static final StandardSubjectBuilder ASSERT = StandardSubjectBuilder.forCustomFailureStrategy(THROW_ASSERTION_ERROR);

    private Truth() {
    }

    public static StandardSubjectBuilder assert_() {
        return ASSERT;
    }

    public static StandardSubjectBuilder assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withMessage(messageToPrepend);
    }

    public static StandardSubjectBuilder assertWithMessage(String format, Object ... args) {
        return Truth.assert_().withMessage(format, args);
    }

    public static <S extends Subject, T> SimpleSubjectBuilder<S, T> assertAbout(Subject.Factory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    public static <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT assertAbout(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return Truth.assert_().about(factory);
    }

    public static <T extends Comparable<?>> ComparableSubject<T> assertThat(T actual) {
        return Truth.assert_().that(actual);
    }

    public static BigDecimalSubject assertThat(BigDecimal actual) {
        return Truth.assert_().that(actual);
    }

    public static Subject assertThat(Object actual) {
        return Truth.assert_().that(actual);
    }

    public static ClassSubject assertThat(Class<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static ThrowableSubject assertThat(Throwable actual) {
        return Truth.assert_().that(actual);
    }

    public static LongSubject assertThat(Long actual) {
        return Truth.assert_().that(actual);
    }

    public static DoubleSubject assertThat(Double actual) {
        return Truth.assert_().that(actual);
    }

    public static FloatSubject assertThat(Float actual) {
        return Truth.assert_().that(actual);
    }

    public static IntegerSubject assertThat(Integer actual) {
        return Truth.assert_().that(actual);
    }

    public static BooleanSubject assertThat(Boolean actual) {
        return Truth.assert_().that(actual);
    }

    public static StringSubject assertThat(String actual) {
        return Truth.assert_().that(actual);
    }

    public static IterableSubject assertThat(Iterable<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static <T> ObjectArraySubject<T> assertThat(T[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveBooleanArraySubject assertThat(boolean[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveShortArraySubject assertThat(short[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveIntArraySubject assertThat(int[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveLongArraySubject assertThat(long[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveByteArraySubject assertThat(byte[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveCharArraySubject assertThat(char[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveFloatArraySubject assertThat(float[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveDoubleArraySubject assertThat(double[] actual) {
        return Truth.assert_().that(actual);
    }

    public static OptionalSubject assertThat(Optional<?> actual) {
        return Truth8.assertThat(actual);
    }

    public static MapSubject assertThat(Map<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    static final class SimpleAssertionError
    extends AssertionError {
        private final Throwable cause;

        private SimpleAssertionError(String message, Throwable cause) {
            super((Object)Objects.requireNonNull(message));
            this.cause = cause;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        static SimpleAssertionError create(String message, Throwable cause) {
            return new SimpleAssertionError(message, cause);
        }

        static SimpleAssertionError createWithNoStack(String message, Throwable cause) {
            SimpleAssertionError error = SimpleAssertionError.create(message, cause);
            error.setStackTrace(new StackTraceElement[0]);
            return error;
        }

        static SimpleAssertionError createWithNoStack(String message) {
            return SimpleAssertionError.createWithNoStack(message, null);
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return this.getLocalizedMessage();
        }
    }
}

