/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Util {
    private Util() {
    }

    static List<Boolean> booleansAsList(boolean ... backingArray) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(backingArray.length);
        for (boolean i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Integer> intsAsList(int ... backingArray) {
        ArrayList<Integer> result = new ArrayList<Integer>(backingArray.length);
        for (int i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Long> longsAsList(long ... backingArray) {
        ArrayList<Long> result = new ArrayList<Long>(backingArray.length);
        for (long i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Short> shortsAsList(short ... backingArray) {
        ArrayList<Short> result = new ArrayList<Short>(backingArray.length);
        for (short i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Float> floatsAsList(float ... backingArray) {
        ArrayList<Float> result = new ArrayList<Float>(backingArray.length);
        for (float i : backingArray) {
            result.add(Float.valueOf(i));
        }
        return result;
    }

    static List<Double> doublesAsList(double ... backingArray) {
        ArrayList<Double> result = new ArrayList<Double>(backingArray.length);
        for (double i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Byte> bytesAsList(byte ... backingArray) {
        ArrayList<Byte> result = new ArrayList<Byte>(backingArray.length);
        for (byte i : backingArray) {
            result.add(i);
        }
        return result;
    }

    static List<Character> charsAsList(char ... backingArray) {
        ArrayList<Character> result = new ArrayList<Character>(backingArray.length);
        for (char i : backingArray) {
            result.add(Character.valueOf(i));
        }
        return result;
    }

    static String padEnd(String string, int minLength, char padChar) {
        if (string.length() >= minLength) {
            return string;
        }
        int paddingLength = minLength - string.length();
        String padding = String.valueOf(padChar).repeat(paddingLength);
        return string + padding;
    }

    static <E> List<E> iterableToList(Iterable<E> iterable) {
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    static <E> Set<E> intersection(Set<E> set1, Set<?> set2) {
        return set1.stream().filter(set2::contains).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static <E> Set<E> union(Set<? extends E> set1, Set<? extends E> set2) {
        LinkedHashSet result = Stream.concat(set1.stream(), set2.stream().filter(e -> !set1.contains(e))).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(result);
    }
}

