/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.Subject;

public abstract class ComparableSubject<T extends Comparable>
extends Subject {
    private final T actual;

    protected ComparableSubject(FailureMetadata metadata, T actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public void isEquivalentAccordingToCompareTo(T expected) {
        if (this.actual.compareTo(expected) != 0) {
            this.failWithActual("expected value that sorts equal to", expected);
        }
    }

    public final void isGreaterThan(T other) {
        if (this.actual.compareTo(other) <= 0) {
            this.failWithActual("expected to be greater than", other);
        }
    }

    public final void isLessThan(T other) {
        if (this.actual.compareTo(other) >= 0) {
            this.failWithActual("expected to be less than", other);
        }
    }

    public final void isAtMost(T other) {
        if (this.actual.compareTo(other) > 0) {
            this.failWithActual("expected to be at most", other);
        }
    }

    public final void isAtLeast(T other) {
        if (this.actual.compareTo(other) < 0) {
            this.failWithActual("expected to be at least", other);
        }
    }
}

