/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.Fact;
import io.jbock.common.truth.Platform;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ComparisonFailures {
    static List<Fact> makeComparisonFailureFacts(List<Fact> headFacts, List<Fact> tailFacts, String expected, String actual) {
        return Stream.of(headFacts, ComparisonFailures.formatExpectedAndActual(expected, actual), tailFacts).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static List<Fact> formatExpectedAndActual(String expected, String actual) {
        List<Fact> result = Platform.makeDiff(expected, actual);
        if (result != null) {
            return result;
        }
        return List.of(Fact.fact("expected", expected), Fact.fact("but was", actual));
    }

    private ComparisonFailures() {
    }
}

