/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.ComparableSubject;
import io.jbock.common.truth.Fact;
import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.MathUtil;
import io.jbock.common.truth.Platform;
import io.jbock.common.truth.Preconditions;
import java.util.Objects;

public final class DoubleSubject
extends ComparableSubject<Double> {
    private static final long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);
    private final Double actual;

    DoubleSubject(FailureMetadata metadata, Double actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public TolerantDoubleComparison isWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = DoubleSubject.this.actual;
                Objects.requireNonNull(actual, () -> String.format("actual value cannot be null. tolerance=%s expected=%s", tolerance, expected));
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithoutActual(Fact.fact("expected", Platform.doubleToString(expected)), DoubleSubject.this.butWas(), Fact.fact("outside tolerance", Platform.doubleToString(tolerance)));
                }
            }
        };
    }

    public TolerantDoubleComparison isNotWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = DoubleSubject.this.actual;
                Objects.requireNonNull(actual, () -> String.format("actual value cannot be null. tolerance=%s expected=%s", tolerance, expected));
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithoutActual(Fact.fact("expected not to be", Platform.doubleToString(expected)), DoubleSubject.this.butWas(), Fact.fact("within tolerance", Platform.doubleToString(tolerance)));
                }
            }
        };
    }

    @Override
    public final void isEqualTo(Object other) {
        super.isEqualTo(other);
    }

    @Override
    public final void isNotEqualTo(Object other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Double other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(double tolerance) {
        Preconditions.checkArgument(!Double.isNaN(tolerance), "tolerance cannot be NaN");
        Preconditions.checkArgument(tolerance >= 0.0, "tolerance (%s) cannot be negative", tolerance);
        Preconditions.checkArgument(Double.doubleToLongBits(tolerance) != NEG_ZERO_BITS, "tolerance (%s) cannot be negative", tolerance);
        Preconditions.checkArgument(tolerance != Double.POSITIVE_INFINITY, "tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isZero() {
        if (this.actual == null || this.actual != 0.0) {
            this.failWithActual(Fact.simpleFact("expected zero"), new Fact[0]);
        }
    }

    public final void isNonZero() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected a double other than zero"), new Fact[0]);
        } else if (this.actual == 0.0) {
            this.failWithActual(Fact.simpleFact("expected not to be zero"), new Fact[0]);
        }
    }

    public final void isPositiveInfinity() {
        this.isEqualTo(Double.POSITIVE_INFINITY);
    }

    public final void isNegativeInfinity() {
        this.isEqualTo(Double.NEGATIVE_INFINITY);
    }

    public final void isNaN() {
        this.isEqualTo(Double.NaN);
    }

    public final void isFinite() {
        if (this.actual == null || this.actual.isNaN() || this.actual.isInfinite()) {
            this.failWithActual(Fact.simpleFact("expected to be finite"), new Fact[0]);
        }
    }

    public final void isNotNaN() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected a double other than NaN"), new Fact[0]);
        } else {
            this.isNotEqualTo(Double.NaN);
        }
    }

    @Override
    public final void isGreaterThan(int other) {
        this.isGreaterThan(Double.valueOf(other));
    }

    @Override
    public final void isLessThan(int other) {
        this.isLessThan(Double.valueOf(other));
    }

    @Override
    public final void isAtMost(int other) {
        this.isAtMost(Double.valueOf(other));
    }

    @Override
    public final void isAtLeast(int other) {
        this.isAtLeast(Double.valueOf(other));
    }

    public static abstract class TolerantDoubleComparison {
        private TolerantDoubleComparison() {
        }

        public abstract void of(double var1);

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException("If you meant to compare doubles, use .of(double) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

