/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.FailureStrategy;
import io.jbock.common.truth.Platform;
import io.jbock.common.truth.SimpleSubjectBuilder;
import io.jbock.common.truth.StandardSubjectBuilder;
import io.jbock.common.truth.Subject;
import io.jbock.common.truth.Truth;
import io.jbock.common.truth.TruthFailureSubject;

public final class ExpectFailure {
    private final FailureStrategy strategy = this::captureFailure;
    private boolean failureExpected = false;
    private AssertionError failure = null;

    ExpectFailure() {
    }

    public StandardSubjectBuilder whenTesting() {
        if (this.failure != null) {
            throw Truth.SimpleAssertionError.create("ExpectFailure already captured a failure", (Throwable)((Object)this.failure));
        }
        if (this.failureExpected) {
            throw new AssertionError((Object)"ExpectFailure.whenTesting() called previously, but did not capture a failure.");
        }
        this.failureExpected = true;
        return StandardSubjectBuilder.forCustomFailureStrategy(this.strategy);
    }

    void enterRuleContext() {
    }

    void ensureFailureCaught() {
        if (this.failureExpected && this.failure == null) {
            throw new AssertionError((Object)"ExpectFailure.whenTesting() invoked, but no failure was caught.");
        }
    }

    public AssertionError getFailure() {
        if (this.failure == null) {
            throw new AssertionError((Object)"ExpectFailure did not capture a failure.");
        }
        return this.failure;
    }

    private void captureFailure(AssertionError captured) {
        if (this.failure != null) {
            throw new AssertionError((Object)String.format("ExpectFailure.whenTesting() caught multiple failures:\n\n%s\n\n%s\n", Platform.getStackTraceAsString((Throwable)((Object)this.failure)), Platform.getStackTraceAsString((Throwable)((Object)captured))));
        }
        this.failure = captured;
    }

    public static AssertionError expectFailure(StandardSubjectBuilderCallback assertionCallback) {
        ExpectFailure expectFailure = new ExpectFailure();
        assertionCallback.invokeAssertion(expectFailure.whenTesting());
        return expectFailure.getFailure();
    }

    public static <S extends Subject, A> AssertionError expectFailureAbout(Subject.Factory<S, A> factory, SimpleSubjectBuilderCallback<S, A> assertionCallback) {
        return ExpectFailure.expectFailure(whenTesting -> assertionCallback.invokeAssertion(whenTesting.about(factory)));
    }

    public static TruthFailureSubject assertThat(AssertionError actual) {
        return Truth.assertAbout(TruthFailureSubject.truthFailures()).that(actual);
    }

    public static interface StandardSubjectBuilderCallback {
        public void invokeAssertion(StandardSubjectBuilder var1);
    }

    public static interface SimpleSubjectBuilderCallback<S extends Subject, A> {
        public void invokeAssertion(SimpleSubjectBuilder<S, A> var1);
    }
}

