/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.AssertionErrorWithFacts;
import io.jbock.common.truth.ComparisonFailures;
import io.jbock.common.truth.Fact;
import io.jbock.common.truth.FailureStrategy;
import io.jbock.common.truth.LazyMessage;
import io.jbock.common.truth.Platform;
import io.jbock.common.truth.Preconditions;
import io.jbock.common.truth.Subject;
import io.jbock.common.truth.SubjectUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class FailureMetadata {
    private final FailureStrategy strategy;
    private final List<LazyMessage> messages;
    private final List<Step> steps;

    static FailureMetadata forFailureStrategy(FailureStrategy failureStrategy) {
        return new FailureMetadata(failureStrategy, List.of(), List.of());
    }

    FailureMetadata(FailureStrategy strategy, List<LazyMessage> messages, List<Step> steps) {
        this.strategy = Objects.requireNonNull(strategy);
        this.messages = Objects.requireNonNull(messages);
        this.steps = Objects.requireNonNull(steps);
    }

    FailureMetadata updateForSubject(Subject subject) {
        List<Step> steps = SubjectUtils.append(this.steps, Step.subjectCreation(subject));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall() {
        List<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(null, null));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall(OldAndNewValuesAreSimilar valuesAreSimilar, Function<String, String> descriptionUpdate) {
        Objects.requireNonNull(descriptionUpdate);
        List<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(valuesAreSimilar, descriptionUpdate));
        return this.derive(this.messages, steps);
    }

    FailureMetadata withMessage(String format, Object[] args) {
        List<LazyMessage> messages = SubjectUtils.append(this.messages, new LazyMessage(format, args));
        return this.derive(messages, this.steps);
    }

    void failEqualityCheck(List<Fact> headFacts, List<Fact> tailFacts, String expected, String actual) {
        this.doFail(Platform.makeComparisonFailure(LazyMessage.evaluateAll(this.messages), ComparisonFailures.makeComparisonFailureFacts(SubjectUtils.concat(this.description(), headFacts), SubjectUtils.concat(tailFacts, this.rootUnlessThrowable()), expected, actual), expected, actual, this.rootCause()));
    }

    void fail(List<Fact> facts) {
        this.doFail(new AssertionErrorWithFacts(LazyMessage.evaluateAll(this.messages), SubjectUtils.concat(this.description(), facts, this.rootUnlessThrowable()), this.rootCause()));
    }

    private void doFail(AssertionError failure) {
        this.strategy.fail(failure);
    }

    private FailureMetadata derive(List<LazyMessage> messages, List<Step> steps) {
        return new FailureMetadata(this.strategy, messages, steps);
    }

    private List<Fact> description() {
        String description = Platform.inferDescription();
        boolean descriptionIsInteresting = description != null;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                Preconditions.checkState(description != null);
                if (step.descriptionUpdate == null) {
                    description = null;
                    descriptionIsInteresting = false;
                    continue;
                }
                description = Objects.requireNonNull(step.descriptionUpdate.apply(description));
                descriptionIsInteresting = true;
                continue;
            }
            if (description != null) continue;
            description = step.subject.typeDescription();
        }
        return descriptionIsInteresting ? List.of(Fact.fact("value of", description)) : List.of();
    }

    private List<Fact> rootUnlessThrowable() {
        Step rootSubject = null;
        boolean seenDerivation = false;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                seenDerivation |= step.descriptionUpdate != null && step.valuesAreSimilar == OldAndNewValuesAreSimilar.DIFFERENT;
                continue;
            }
            if (rootSubject != null) continue;
            if (step.subject.actual() instanceof Throwable) {
                return List.of();
            }
            rootSubject = step;
        }
        return seenDerivation ? List.of(Fact.fact(rootSubject.subject.typeDescription() + " was", rootSubject.subject.actualCustomStringRepresentationForPackageMembersToCall())) : List.of();
    }

    private Throwable rootCause() {
        for (Step step : this.steps) {
            if (step.isCheckCall() || !(step.subject.actual() instanceof Throwable)) continue;
            return (Throwable)step.subject.actual();
        }
        return null;
    }

    private static final class Step {
        final Subject subject;
        final Function<String, String> descriptionUpdate;
        final OldAndNewValuesAreSimilar valuesAreSimilar;

        static Step subjectCreation(Subject subject) {
            return new Step(Objects.requireNonNull(subject), null, null);
        }

        static Step checkCall(OldAndNewValuesAreSimilar valuesAreSimilar, Function<String, String> descriptionUpdate) {
            return new Step(null, descriptionUpdate, valuesAreSimilar);
        }

        private Step(Subject subject, Function<String, String> descriptionUpdate, OldAndNewValuesAreSimilar valuesAreSimilar) {
            this.subject = subject;
            this.descriptionUpdate = descriptionUpdate;
            this.valuesAreSimilar = valuesAreSimilar;
        }

        boolean isCheckCall() {
            return this.subject == null;
        }
    }

    static enum OldAndNewValuesAreSimilar {
        SIMILAR,
        DIFFERENT;

    }
}

