/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.ComparableSubject;
import io.jbock.common.truth.DoubleSubject;
import io.jbock.common.truth.Fact;
import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.MathUtil;
import io.jbock.common.truth.Platform;
import io.jbock.common.truth.Preconditions;
import java.util.Objects;

public final class FloatSubject
extends ComparableSubject<Float> {
    private static final int NEG_ZERO_BITS = Float.floatToIntBits(-0.0f);
    private final Float actual;
    private final DoubleSubject asDouble;

    FloatSubject(FailureMetadata metadata, Float actual) {
        super(metadata, actual);
        this.actual = actual;
        this.asDouble = new DoubleSubject(metadata, actual == null ? null : Double.valueOf(actual.floatValue()));
    }

    public TolerantFloatComparison isWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = FloatSubject.this.actual;
                Objects.requireNonNull(actual, () -> String.format("actual value cannot be null. tolerance=%s expected=%s", Float.valueOf(tolerance), Float.valueOf(expected)));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithoutActual(Fact.fact("expected", Platform.floatToString(expected)), FloatSubject.this.butWas(), Fact.fact("outside tolerance", Platform.floatToString(tolerance)));
                }
            }
        };
    }

    public TolerantFloatComparison isNotWithin(final float tolerance) {
        return new TolerantFloatComparison(){

            @Override
            public void of(float expected) {
                Float actual = FloatSubject.this.actual;
                Objects.requireNonNull(actual, () -> String.format("actual value cannot be null. tolerance=%s expected=%s", Float.valueOf(tolerance), Float.valueOf(expected)));
                FloatSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual.floatValue(), expected, tolerance)) {
                    FloatSubject.this.failWithoutActual(Fact.fact("expected not to be", Platform.floatToString(expected)), FloatSubject.this.butWas(), Fact.fact("within tolerance", Platform.floatToString(tolerance)));
                }
            }
        };
    }

    @Override
    public void isEqualTo(Object other) {
        super.isEqualTo(other);
    }

    @Override
    public void isNotEqualTo(Object other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public void isEquivalentAccordingToCompareTo(Float other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(float tolerance) {
        Preconditions.checkArgument(!Float.isNaN(tolerance), "tolerance cannot be NaN");
        Preconditions.checkArgument(tolerance >= 0.0f, "tolerance (%s) cannot be negative", Float.valueOf(tolerance));
        Preconditions.checkArgument(Float.floatToIntBits(tolerance) != NEG_ZERO_BITS, "tolerance (%s) cannot be negative", Float.valueOf(tolerance));
        Preconditions.checkArgument(tolerance != Float.POSITIVE_INFINITY, "tolerance cannot be POSITIVE_INFINITY");
    }

    public void isZero() {
        if (this.actual == null || this.actual.floatValue() != 0.0f) {
            this.failWithActual(Fact.simpleFact("expected zero"), new Fact[0]);
        }
    }

    public void isNonZero() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected a float other than zero"), new Fact[0]);
        } else if (this.actual.floatValue() == 0.0f) {
            this.failWithActual(Fact.simpleFact("expected not to be zero"), new Fact[0]);
        }
    }

    public void isPositiveInfinity() {
        this.isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public void isNegativeInfinity() {
        this.isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
    }

    public void isNaN() {
        this.isEqualTo(Float.valueOf(Float.NaN));
    }

    public void isFinite() {
        if (this.actual == null || this.actual.isNaN() || this.actual.isInfinite()) {
            this.failWithActual(Fact.simpleFact("expected to be finite"), new Fact[0]);
        }
    }

    public void isNotNaN() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected a float other than NaN"), new Fact[0]);
        } else {
            this.isNotEqualTo(Float.valueOf(Float.NaN));
        }
    }

    @Override
    public void isGreaterThan(int other) {
        this.asDouble.isGreaterThan(other);
    }

    @Override
    public void isLessThan(int other) {
        this.asDouble.isLessThan(other);
    }

    @Override
    public void isAtMost(int other) {
        this.asDouble.isAtMost(other);
    }

    @Override
    public void isAtLeast(int other) {
        this.asDouble.isAtLeast(other);
    }

    public static abstract class TolerantFloatComparison {
        private TolerantFloatComparison() {
        }

        public abstract void of(float var1);

        @Deprecated
        public boolean equals(Object o) {
            throw new UnsupportedOperationException("If you meant to compare floats, use .of(float) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

