/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.Ordered;
import io.jbock.common.truth.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class IntStreamSubject
extends Subject {
    private final List<?> actualList;

    private IntStreamSubject(FailureMetadata failureMetadata, IntStream stream) {
        super(failureMetadata, stream);
        this.actualList = stream == null ? null : (List)stream.boxed().collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<IntStreamSubject, IntStream> intStreams() {
        return IntStreamSubject::new;
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(int element) {
        this.check().that(this.actualList).contains(element);
    }

    public void doesNotContain(int element) {
        this.check().that(this.actualList).doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsAnyOf(first, second, IntStreamSubject.box(rest));
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    public Ordered containsAtLeast(int first, int second, int ... rest) {
        return this.check().that(this.actualList).containsAtLeast(first, second, IntStreamSubject.box(rest));
    }

    public Ordered containsAtLeastElementsIn(Collection<?> expected) {
        return this.check().that(this.actualList).containsAtLeastElementsIn(expected);
    }

    public Ordered containsExactly(int ... varargs) {
        return this.check().that(this.actualList).containsExactly(IntStreamSubject.box(varargs));
    }

    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(int first, int second, int ... rest) {
        this.check().that(this.actualList).containsNoneOf(first, second, IntStreamSubject.box(rest));
    }

    public void containsNoneIn(Collection<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    public void isInStrictOrder() {
        this.check().that(this.actualList).isInStrictOrder();
    }

    public void isInStrictOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInStrictOrder(comparator);
    }

    public void isInOrder() {
        this.check().that(this.actualList).isInOrder();
    }

    public void isInOrder(Comparator<? super Integer> comparator) {
        this.check().that(this.actualList).isInOrder(comparator);
    }

    private static Object[] box(int[] rest) {
        return IntStream.of(rest).boxed().toArray(Integer[]::new);
    }
}

