/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.AssertionErrorWithFacts;
import io.jbock.common.truth.DiffUtils;
import io.jbock.common.truth.Fact;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

final class Platform {
    private static final String DIFF_KEY = "diff (-expected +actual)";

    private Platform() {
    }

    static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        return clazz.isInstance(instance);
    }

    static boolean containsMatch(String actual, String regex) {
        return Pattern.compile(regex).matcher(actual).find();
    }

    static String inferDescription() {
        return null;
    }

    static List<Fact> makeDiff(String expected, String actual) {
        List<String> actualLines;
        List<String> expectedLines = Platform.splitLines(expected);
        List<String> unifiedDiff = DiffUtils.generateUnifiedDiff(expectedLines, actualLines = Platform.splitLines(actual), 3);
        if (unifiedDiff.isEmpty()) {
            return List.of(Fact.fact(DIFF_KEY, "(line contents match, but line-break characters differ)"));
        }
        String result = String.join((CharSequence)"\n", unifiedDiff);
        if (result.length() > expected.length() && result.length() > actual.length()) {
            return null;
        }
        return List.of(Fact.fact(DIFF_KEY, result));
    }

    private static List<String> splitLines(String s) {
        return Arrays.asList(s.split("\r?\n", -1));
    }

    static String doubleToString(double value) {
        return Double.toString(value);
    }

    static String floatToString(float value) {
        return Float.toString(value);
    }

    static String stringValueOfNonFloatingPoint(Object o) {
        return String.valueOf(o);
    }

    static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static AssertionError makeComparisonFailure(List<String> messages, List<Fact> facts, String expected, String actual, Throwable cause) {
        Constructor<AssertionError> constructor;
        Class<?> comparisonFailureClass;
        try {
            comparisonFailureClass = Class.forName("io.jbock.common.truth.ComparisonFailureWithFacts");
        }
        catch (ClassNotFoundException | LinkageError probablyJunitNotOnClasspath) {
            return new AssertionErrorWithFacts(messages, facts, cause);
        }
        Class<AssertionError> asAssertionErrorSubclass = comparisonFailureClass.asSubclass(AssertionError.class);
        try {
            constructor = asAssertionErrorSubclass.getDeclaredConstructor(List.class, List.class, String.class, String.class, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw Platform.newLinkageError(e);
        }
        try {
            return constructor.newInstance(messages, facts, expected, actual, cause);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw Platform.newLinkageError(e);
        }
        catch (InstantiationException e) {
            throw Platform.newLinkageError(e);
        }
        catch (IllegalAccessException e) {
            throw Platform.newLinkageError(e);
        }
    }

    private static LinkageError newLinkageError(Throwable cause) {
        LinkageError error = new LinkageError(cause.toString());
        error.initCause(cause);
        return error;
    }

    static abstract class PlatformComparisonFailure
    extends AssertionError {
        private final String message;
        private final String fExpected;
        private final String fActual;
        private final Throwable cause;

        PlatformComparisonFailure(String message, String expected, String actual, Throwable cause) {
            this.message = message;
            this.cause = cause;
            this.fActual = actual;
            this.fExpected = expected;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public final String getMessage() {
            return this.message;
        }

        public String getActual() {
            return this.fActual;
        }

        public String getExpected() {
            return this.fExpected;
        }

        public final Throwable getCause() {
            return this.cause;
        }

        public final String toString() {
            return this.getLocalizedMessage();
        }
    }
}

