/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.AbstractArraySubject;
import io.jbock.common.truth.Correspondence;
import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.IterableSubject;
import io.jbock.common.truth.Ordered;
import io.jbock.common.truth.Preconditions;
import io.jbock.common.truth.Subject;
import io.jbock.common.truth.Util;
import java.util.Objects;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject {
    private final float[] actual;
    private static final Correspondence<Float, Number> EXACT_EQUALITY_CORRESPONDENCE = Correspondence.from((actual, expected) -> Float.floatToIntBits(actual.floatValue()) == Float.floatToIntBits(PrimitiveFloatArraySubject.checkedToFloat(expected)), "is exactly equal to");

    PrimitiveFloatArraySubject(FailureMetadata metadata, float[] o, String typeDescription) {
        super(metadata, o, typeDescription);
        this.actual = o;
    }

    @Override
    public void isEqualTo(Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(Object expected) {
        super.isNotEqualTo(expected);
    }

    public FloatArrayAsIterable usingTolerance(double tolerance) {
        return new FloatArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static float checkedToFloat(Number expected) {
        Objects.requireNonNull(expected);
        Preconditions.checkArgument(!(expected instanceof Double), "Expected value in assertion using exact float equality was a double, which is not supported as a double may not have an exact float representation");
        Preconditions.checkArgument(expected instanceof Float || expected instanceof Integer || expected instanceof Long, "Expected value in assertion using exact float equality was of unsupported type %s (it may not have an exact float representation)", expected.getClass());
        if (expected instanceof Integer) {
            Preconditions.checkArgument(Math.abs((Integer)expected) <= 0x1000000, "Expected value %s in assertion using exact float equality was an int with an absolute value greater than 2^24 which has no exact float representation", expected);
        }
        if (expected instanceof Long) {
            Preconditions.checkArgument(Math.abs((Long)expected) <= 0x1000000L, "Expected value %s in assertion using exact float equality was a long with an absolute value greater than 2^24 which has no exact float representation", expected);
        }
        return expected.floatValue();
    }

    public FloatArrayAsIterable usingExactEquality() {
        return new FloatArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomFloatToString()).that(Util.floatsAsList(this.actual));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomFloatToString() {
        return (x$0, x$1) -> new IterableSubjectWithInheritedToString(x$0, (Iterable<?>)x$1);
    }

    public static final class FloatArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Float, Number> {
        FloatArrayAsIterable(Correspondence<? super Float, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        public Ordered containsAtLeast(float[] expected) {
            return this.containsAtLeastElementsIn(Util.floatsAsList(expected));
        }

        public void containsAnyOf(float[] expected) {
            this.containsAnyIn(Util.floatsAsList(expected));
        }

        public Ordered containsExactly(float[] expected) {
            return this.containsExactlyElementsIn(Util.floatsAsList(expected));
        }

        public void containsNoneOf(float[] excluded) {
            this.containsNoneIn(Util.floatsAsList(excluded));
        }
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(FailureMetadata metadata, Iterable<?> actual) {
            super(metadata, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveFloatArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }
}

