/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.Ordered;
import io.jbock.common.truth.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StreamSubject
extends Subject {
    private final List<?> actualList;

    private StreamSubject(FailureMetadata failureMetadata, Stream<?> stream) {
        super(failureMetadata, stream);
        this.actualList = stream == null ? null : (List)stream.collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<StreamSubject, Stream<?>> streams() {
        return (metadata, subject) -> new StreamSubject(metadata, (Stream<?>)subject);
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(Object element) {
        this.check().that(this.actualList).contains(element);
    }

    public void doesNotContain(Object element) {
        this.check().that(this.actualList).doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(Object first, Object second, Object ... rest) {
        this.check().that(this.actualList).containsAnyOf(first, second, rest);
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    public Ordered containsAtLeast(Object first, Object second, Object ... rest) {
        return this.check().that(this.actualList).containsAtLeast(first, second, rest);
    }

    public Ordered containsAtLeastElementsIn(Collection<?> expected) {
        return this.check().that(this.actualList).containsAtLeastElementsIn(expected);
    }

    public Ordered containsExactly(Object ... varargs) {
        return this.check().that(this.actualList).containsExactly(varargs);
    }

    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(Object first, Object second, Object ... rest) {
        this.check().that(this.actualList).containsNoneOf(first, second, rest);
    }

    public void containsNoneIn(Collection<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    public void isInStrictOrder() {
        this.check().that(this.actualList).isInStrictOrder();
    }

    public void isInStrictOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isInStrictOrder(comparator);
    }

    public void isInOrder() {
        this.check().that(this.actualList).isInOrder();
    }

    public void isInOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isInOrder(comparator);
    }
}

