/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.ErrorWithFacts;
import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.StandardSubjectBuilder;
import io.jbock.common.truth.StringSubject;
import io.jbock.common.truth.Subject;

public class ThrowableSubject
extends Subject {
    private final Throwable actual;

    protected ThrowableSubject(FailureMetadata metadata, Throwable throwable) {
        this(metadata, throwable, null);
    }

    ThrowableSubject(FailureMetadata metadata, Throwable throwable, String typeDescription) {
        super(metadata, throwable, typeDescription);
        this.actual = throwable;
    }

    public final StringSubject hasMessageThat() {
        StandardSubjectBuilder check = this.check("getMessage()", new Object[0]);
        if (this.actual instanceof ErrorWithFacts && ((ErrorWithFacts)((Object)this.actual)).facts().size() > 1) {
            check = check.withMessage("(Note from Truth: When possible, instead of asserting on the full message, assert about individual facts by using ExpectFailure.assertThat.)");
        }
        return check.that(this.actual.getMessage());
    }

    public final ThrowableSubject hasCauseThat() {
        if (this.actual == null) {
            this.check("getCause()", new Object[0]).withMessage("Causal chain is not deep enough - add a .isNotNull() check?").fail();
            return this.ignoreCheck().that(new Throwable(){

                @Override
                public Throwable fillInStackTrace() {
                    this.setStackTrace(new StackTraceElement[0]);
                    return this;
                }
            });
        }
        return this.check("getCause()", new Object[0]).that(this.actual.getCause());
    }
}

