/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.common.truth;

import io.jbock.common.truth.ErrorWithFacts;
import io.jbock.common.truth.Fact;
import io.jbock.common.truth.FailureMetadata;
import io.jbock.common.truth.IterableSubject;
import io.jbock.common.truth.Preconditions;
import io.jbock.common.truth.StandardSubjectBuilder;
import io.jbock.common.truth.StringSubject;
import io.jbock.common.truth.Subject;
import io.jbock.common.truth.ThrowableSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TruthFailureSubject
extends ThrowableSubject {
    static final Fact HOW_TO_TEST_KEYS_WITHOUT_VALUES = Fact.simpleFact("To test that a key is present without a value, use factKeys().contains(...) or a similar method.");
    private static final Subject.Factory<TruthFailureSubject, AssertionError> FACTORY = new Subject.Factory<TruthFailureSubject, AssertionError>(){

        @Override
        public TruthFailureSubject createSubject(FailureMetadata metadata, AssertionError actual) {
            return new TruthFailureSubject(metadata, actual, "failure");
        }
    };
    private final AssertionError actual;

    public static Subject.Factory<TruthFailureSubject, AssertionError> truthFailures() {
        return FACTORY;
    }

    TruthFailureSubject(FailureMetadata metadata, AssertionError actual, String typeDescription) {
        super(metadata, (Throwable)((Object)actual), typeDescription);
        this.actual = actual;
    }

    public IterableSubject factKeys() {
        if (!(this.actual instanceof ErrorWithFacts)) {
            this.failWithActual(Fact.simpleFact("expected a failure thrown by Truth's new failure API"), new Fact[0]);
            return this.ignoreCheck().that(List.of());
        }
        ErrorWithFacts error = (ErrorWithFacts)((Object)this.actual);
        return this.check("factKeys()", new Object[0]).that(TruthFailureSubject.getFactKeys(error));
    }

    private static List<String> getFactKeys(ErrorWithFacts error) {
        ArrayList<String> facts = new ArrayList<String>();
        for (Fact fact : error.facts()) {
            facts.add(fact.key);
        }
        return facts;
    }

    public StringSubject factValue(String key) {
        return this.doFactValue(key, null);
    }

    public StringSubject factValue(String key, int index) {
        Preconditions.checkArgument(index >= 0, "index must be nonnegative: %s", index);
        return this.doFactValue(key, index);
    }

    private StringSubject doFactValue(String key, Integer index) {
        Objects.requireNonNull(key);
        if (!(this.actual instanceof ErrorWithFacts)) {
            this.failWithActual(Fact.simpleFact("expected a failure thrown by Truth's new failure API"), new Fact[0]);
            return this.ignoreCheck().that("");
        }
        ErrorWithFacts error = (ErrorWithFacts)((Object)this.actual);
        List<Fact> factsWithName = TruthFailureSubject.factsWithName(error, key);
        if (factsWithName.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected to contain fact", key), Fact.fact("but contained only", TruthFailureSubject.getFactKeys(error)));
            return this.ignoreCheck().that("");
        }
        if (index == null && factsWithName.size() > 1) {
            this.failWithoutActual(Fact.fact("expected to contain a single fact with key", key), Fact.fact("but contained multiple", factsWithName));
            return this.ignoreCheck().that("");
        }
        if (index != null && index > factsWithName.size()) {
            this.failWithoutActual(Fact.fact("for key", key), Fact.fact("index too high", index), Fact.fact("fact count was", factsWithName.size()));
            return this.ignoreCheck().that("");
        }
        String value = factsWithName.get((int)(index != null ? index.intValue() : 0)).value;
        if (value == null) {
            if (index == null) {
                this.failWithoutActual(Fact.simpleFact("expected to have a value"), Fact.fact("for key", key), Fact.simpleFact("but the key was present with no value"), HOW_TO_TEST_KEYS_WITHOUT_VALUES);
            } else {
                this.failWithoutActual(Fact.simpleFact("expected to have a value"), Fact.fact("for key", key), Fact.fact("and index", index), Fact.simpleFact("but the key was present with no value"), HOW_TO_TEST_KEYS_WITHOUT_VALUES);
            }
            return this.ignoreCheck().that("");
        }
        StandardSubjectBuilder check = index == null ? this.check("factValue(%s)", key) : this.check("factValue(%s, %s)", key, index);
        return check.that(value);
    }

    private static List<Fact> factsWithName(ErrorWithFacts error, String key) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Fact fact : error.facts()) {
            if (!fact.key.equals(key)) continue;
            facts.add(fact);
        }
        return facts;
    }
}

