/*
 * Decompiled with CFR 0.152.
 */
package pact4s.provider;

import java.io.File;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import pact4s.provider.Authentication;
import pact4s.provider.Branch;
import pact4s.provider.ConsumerVersionSelectors;
import pact4s.provider.ConsumerVersionSelectors$;
import pact4s.provider.PactSource$;
import pact4s.provider.PactSource$FileSource$;
import pact4s.provider.PactSource$PactBrokerWithSelectors$;
import pact4s.provider.PactSource$PactBrokerWithTags$;
import pact4s.provider.ProviderTags;
import pact4s.provider.WipPactsSince;
import pact4s.provider.WipPactsSince$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public interface PactSource {

    public static final class FileSource
    implements PactSource {
        private final Map consumers;

        public static FileSource apply(Map<String, File> map) {
            return PactSource$FileSource$.MODULE$.apply(map);
        }

        public static FileSource apply(Tuple2<String, File> tuple2, Seq<Tuple2<String, File>> seq) {
            return PactSource$FileSource$.MODULE$.apply(tuple2, seq);
        }

        public FileSource(Map<String, File> consumers) {
            this.consumers = consumers;
        }

        public Map<String, File> consumers() {
            return this.consumers;
        }
    }

    public static interface PactBroker
    extends PactSource {
        public String brokerUrl();

        public Option<Authentication> auth();

        public boolean insecureTLS();
    }

    public static final class PactBrokerWithSelectors
    implements PactBroker {
        private final String brokerUrl;
        private final boolean insecureTLS;
        private final Option auth;
        private final boolean enablePending;
        private final WipPactsSince includeWipPactsSince;
        private final Option providerTags;
        private final ConsumerVersionSelectors consumerVersionSelectors;

        public static PactBrokerWithSelectors apply(String string) {
            return PactSource$PactBrokerWithSelectors$.MODULE$.apply(string);
        }

        public PactBrokerWithSelectors(String brokerUrl, boolean insecureTLS, Option<Authentication> auth, boolean enablePending, WipPactsSince includeWipPactsSince, Option<ProviderTags> providerTags, ConsumerVersionSelectors consumerVersionSelectors) {
            this.brokerUrl = brokerUrl;
            this.insecureTLS = insecureTLS;
            this.auth = auth;
            this.enablePending = enablePending;
            this.includeWipPactsSince = includeWipPactsSince;
            this.providerTags = providerTags;
            this.consumerVersionSelectors = consumerVersionSelectors;
        }

        @Override
        public String brokerUrl() {
            return this.brokerUrl;
        }

        @Override
        public boolean insecureTLS() {
            return this.insecureTLS;
        }

        @Override
        public Option<Authentication> auth() {
            return this.auth;
        }

        public boolean enablePending() {
            return this.enablePending;
        }

        public WipPactsSince includeWipPactsSince() {
            return this.includeWipPactsSince;
        }

        public Option<ProviderTags> providerTags() {
            return this.providerTags;
        }

        public ConsumerVersionSelectors consumerVersionSelectors() {
            return this.consumerVersionSelectors;
        }

        private PactBrokerWithSelectors copy(String brokerUrl, boolean insecureTLS, Option<Authentication> auth, boolean enablePending, WipPactsSince includeWipPactsSince, Option<ProviderTags> providerTags, ConsumerVersionSelectors consumerVersionSelectors) {
            return new PactBrokerWithSelectors(brokerUrl, insecureTLS, auth, enablePending, includeWipPactsSince, providerTags, consumerVersionSelectors);
        }

        private String copy$default$1() {
            return this.brokerUrl();
        }

        private boolean copy$default$2() {
            return this.insecureTLS();
        }

        private Option<Authentication> copy$default$3() {
            return this.auth();
        }

        private boolean copy$default$4() {
            return this.enablePending();
        }

        private WipPactsSince copy$default$5() {
            return this.includeWipPactsSince();
        }

        private Option<ProviderTags> copy$default$6() {
            return this.providerTags();
        }

        private ConsumerVersionSelectors copy$default$7() {
            return this.consumerVersionSelectors();
        }

        public PactBrokerWithSelectors withOptionalAuth(Option<Authentication> auth) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), auth, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        public PactBrokerWithSelectors withAuth(Authentication auth) {
            return this.withOptionalAuth((Option<Authentication>)Some$.MODULE$.apply((Object)auth));
        }

        public PactBrokerWithSelectors withPendingPactsEnabled(ProviderTags providerTags) {
            return this.withPendingPacts(true).withProviderTags(providerTags);
        }

        public PactBrokerWithSelectors withPendingPactsEnabled() {
            return this.withPendingPacts(true);
        }

        public PactBrokerWithSelectors withPendingPactsDisabled() {
            return this.withPendingPacts(false);
        }

        public PactBrokerWithSelectors withPendingPacts(boolean enabled) {
            WipPactsSince wipPactsSince = enabled ? this.includeWipPactsSince() : WipPactsSince$.MODULE$.never();
            String string = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Option<Authentication> option = this.copy$default$3();
            Option<ProviderTags> option2 = this.copy$default$6();
            ConsumerVersionSelectors consumerVersionSelectors = this.copy$default$7();
            return this.copy(string, bl, option, enabled, wipPactsSince, option2, consumerVersionSelectors);
        }

        public PactBrokerWithSelectors withWipPactsSince(Instant since, ProviderTags providerTags) {
            return this.withWipPactsSince(WipPactsSince$.MODULE$.instant(since)).withProviderTags(providerTags);
        }

        public PactBrokerWithSelectors withWipPactsSince(LocalDate since, ProviderTags providerTags) {
            return this.withWipPactsSince(WipPactsSince$.MODULE$.localDate(since)).withProviderTags(providerTags);
        }

        public PactBrokerWithSelectors withWipPactsSince(OffsetDateTime since, ProviderTags providerTags) {
            return this.withWipPactsSince(WipPactsSince$.MODULE$.offsetDateTime(since)).withProviderTags(providerTags);
        }

        public PactBrokerWithSelectors withWipPactsSince(WipPactsSince since) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), true, since, this.copy$default$6(), this.copy$default$7());
        }

        public PactBrokerWithSelectors withProviderTags(ProviderTags providerTags) {
            Some some = Some$.MODULE$.apply((Object)providerTags);
            String string = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Option<Authentication> option = this.copy$default$3();
            boolean bl2 = this.copy$default$4();
            WipPactsSince wipPactsSince = this.copy$default$5();
            ConsumerVersionSelectors consumerVersionSelectors = this.copy$default$7();
            return this.copy(string, bl, option, bl2, wipPactsSince, (Option<ProviderTags>)some, consumerVersionSelectors);
        }

        public PactBrokerWithSelectors withOptionalProviderTags(Option<ProviderTags> providerTags) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), providerTags, this.copy$default$7());
        }

        public PactBrokerWithSelectors withConsumerVersionSelectors(ConsumerVersionSelectors selectors) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), selectors);
        }

        public PactBrokerWithSelectors withInsecureTLS(boolean insecureTLS) {
            return this.copy(this.copy$default$1(), insecureTLS, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        public Either<Throwable, BoxedUnit> validate(Option<Branch> providerBranch) {
            if (this.enablePending() && this.providerTags().isEmpty() && providerBranch.isEmpty()) {
                return package$.MODULE$.Left().apply((Object)new IllegalArgumentException("Provider branch (or previously tags) must be provided if pending pacts are enabled"));
            }
            if (this.includeWipPactsSince().since().isDefined() && this.providerTags().isEmpty() && providerBranch.isEmpty()) {
                return package$.MODULE$.Left().apply((Object)new IllegalArgumentException("Provider branch (or previously tags) must be provided if WIP pacts are enabled"));
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
    }

    public static final class PactBrokerWithTags
    implements PactBroker {
        private final String brokerUrl;
        private final boolean insecureTLS;
        private final Option auth;
        private final List tags;

        public static PactBrokerWithTags apply(String string) {
            return PactSource$PactBrokerWithTags$.MODULE$.apply(string);
        }

        public PactBrokerWithTags(String brokerUrl, boolean insecureTLS, Option<Authentication> auth, List<String> tags) {
            this.brokerUrl = brokerUrl;
            this.insecureTLS = insecureTLS;
            this.auth = auth;
            this.tags = tags;
        }

        @Override
        public String brokerUrl() {
            return this.brokerUrl;
        }

        @Override
        public boolean insecureTLS() {
            return this.insecureTLS;
        }

        @Override
        public Option<Authentication> auth() {
            return this.auth;
        }

        public List<String> tags() {
            return this.tags;
        }

        private PactBrokerWithTags copy(String brokerUrl, boolean insecureTLS, Option<Authentication> auth, List<String> tags) {
            return new PactBrokerWithTags(brokerUrl, insecureTLS, auth, tags);
        }

        private String copy$default$1() {
            return this.brokerUrl();
        }

        private boolean copy$default$2() {
            return false;
        }

        private Option<Authentication> copy$default$3() {
            return None$.MODULE$;
        }

        private List<String> copy$default$4() {
            return package$.MODULE$.Nil();
        }

        public PactBrokerWithTags withAuth(Authentication auth) {
            Some some = Some$.MODULE$.apply((Object)auth);
            String string = this.copy$default$1();
            boolean bl = this.copy$default$2();
            List<String> list = this.copy$default$4();
            return this.copy(string, bl, (Option<Authentication>)some, list);
        }

        public PactBrokerWithTags withoutAuth() {
            None$ none$ = None$.MODULE$;
            String string = this.copy$default$1();
            boolean bl = this.copy$default$2();
            List<String> list = this.copy$default$4();
            return this.copy(string, bl, (Option<Authentication>)none$, list);
        }

        public PactBrokerWithTags withTags(List<String> tags) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), tags);
        }

        public PactBrokerWithTags withTags(Seq<String> tags) {
            List list = tags.toList();
            String string = this.copy$default$1();
            boolean bl = this.copy$default$2();
            Option<Authentication> option = this.copy$default$3();
            return this.copy(string, bl, option, (List<String>)list);
        }

        public PactBrokerWithTags withInsecureTLS(boolean insecureTLS) {
            return this.copy(this.copy$default$1(), insecureTLS, this.copy$default$3(), this.copy$default$4());
        }

        public PactBrokerWithSelectors toPactBrokerWithSelectors() {
            return PactSource$PactBrokerWithSelectors$.MODULE$.apply(this.brokerUrl()).withOptionalAuth(this.auth()).withConsumerVersionSelectors((ConsumerVersionSelectors)this.tags().foldLeft((Object)ConsumerVersionSelectors$.MODULE$.apply(), PactSource$::pact4s$provider$PactSource$PactBrokerWithTags$$_$toPactBrokerWithSelectors$$anonfun$1)).withInsecureTLS(this.insecureTLS());
        }
    }
}

