/*
 * Decompiled with CFR 0.152.
 */
package pact4s.provider;

import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.support.Auth;
import au.com.dius.pact.provider.PactBrokerOptions;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.ProviderInfo;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import kotlin.Unit;
import org.apache.hc.core5.http.HttpRequest;
import pact4s.provider.Authentication;
import pact4s.provider.Authentication$BasicAuth$;
import pact4s.provider.Authentication$TokenAuth$;
import pact4s.provider.Branch;
import pact4s.provider.PactSource;
import pact4s.provider.ProviderInfoBuilder$;
import pact4s.provider.ProviderRequest;
import pact4s.provider.ProviderRequest$;
import pact4s.provider.ProviderRequestFilter;
import pact4s.provider.ProviderState;
import pact4s.provider.ResponseBuilder;
import pact4s.provider.StateManagement;
import pact4s.provider.StateManagement$ProviderUrl$;
import pact4s.provider.StateManagement$StateManagementFunction$;
import pact4s.provider.VerificationSettings;
import pact4s.provider.VerificationSettings$AnnotatedMethodVerificationSettings$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

public final class ProviderInfoBuilder {
    private final String name;
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final PactSource pactSource;
    private final Option<StateManagement> stateManagement;
    private final Option<VerificationSettings> verificationSettings;
    private final Function1<ProviderRequest, Option<ProviderRequestFilter>> requestFilter;

    public static ProviderInfoBuilder apply(String string, PactSource pactSource) {
        return ProviderInfoBuilder$.MODULE$.apply(string, pactSource);
    }

    public static ProviderInfoBuilder apply(String string, String string2, String string3, int n, String string4, PactSource pactSource) {
        return ProviderInfoBuilder$.MODULE$.apply(string, string2, string3, n, string4, pactSource);
    }

    public static ProviderInfoBuilder apply(String string, URL uRL, PactSource pactSource) {
        return ProviderInfoBuilder$.MODULE$.apply(string, uRL, pactSource);
    }

    public ProviderInfoBuilder(String name, String protocol, String host, int port, String path, PactSource pactSource, Option<StateManagement> stateManagement, Option<VerificationSettings> verificationSettings, Function1<ProviderRequest, Option<ProviderRequestFilter>> requestFilter) {
        this.name = name;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.pactSource = pactSource;
        this.stateManagement = stateManagement;
        this.verificationSettings = verificationSettings;
        this.requestFilter = requestFilter;
    }

    private ProviderInfoBuilder copy(String name, String protocol, String host, int port, String path, PactSource pactSource, Option<StateManagement> stateManagement, Option<VerificationSettings> verificationSettings, Function1<ProviderRequest, Option<ProviderRequestFilter>> requestFilter) {
        return new ProviderInfoBuilder(name, protocol, host, port, path, pactSource, stateManagement, verificationSettings, requestFilter);
    }

    private String copy$default$1() {
        return this.name;
    }

    private String copy$default$2() {
        return this.protocol;
    }

    private String copy$default$3() {
        return this.host;
    }

    private int copy$default$4() {
        return this.port;
    }

    private String copy$default$5() {
        return this.path;
    }

    private PactSource copy$default$6() {
        return this.pactSource;
    }

    private Option<StateManagement> copy$default$7() {
        return this.stateManagement;
    }

    private Option<VerificationSettings> copy$default$8() {
        return this.verificationSettings;
    }

    private Function1<ProviderRequest, Option<ProviderRequestFilter>> copy$default$9() {
        return this.requestFilter;
    }

    public Option<StateManagement> getStateManagement() {
        return this.stateManagement;
    }

    public ProviderInfoBuilder withProtocol(String protocol) {
        return this.copy(this.copy$default$1(), protocol, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    public ProviderInfoBuilder withHost(String host) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), host, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    public ProviderInfoBuilder withPort(int port) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), port, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    public ProviderInfoBuilder withPath(String path) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), path, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    public ProviderInfoBuilder withVerificationSettings(VerificationSettings settings) {
        Some some = Some$.MODULE$.apply((Object)settings);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        String string3 = this.copy$default$3();
        int n = this.copy$default$4();
        String string4 = this.copy$default$5();
        PactSource pactSource = this.copy$default$6();
        Option<StateManagement> option = this.copy$default$7();
        Function1<ProviderRequest, Option<ProviderRequestFilter>> function1 = this.copy$default$9();
        return this.copy(string, string2, string3, n, string4, pactSource, option, (Option<VerificationSettings>)some, function1);
    }

    public ProviderInfoBuilder withOptionalVerificationSettings(Option<VerificationSettings> settings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), settings, this.copy$default$9());
    }

    public ProviderInfoBuilder withStateChangeUrl(String url) {
        Some some = Some$.MODULE$.apply((Object)StateManagement$ProviderUrl$.MODULE$.apply(url));
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        String string3 = this.copy$default$3();
        int n = this.copy$default$4();
        String string4 = this.copy$default$5();
        PactSource pactSource = this.copy$default$6();
        Option<VerificationSettings> option = this.copy$default$8();
        Function1<ProviderRequest, Option<ProviderRequestFilter>> function1 = this.copy$default$9();
        return this.copy(string, string2, string3, n, string4, pactSource, (Option<StateManagement>)some, option, function1);
    }

    public ProviderInfoBuilder withStateChangeEndpoint(String endpoint) {
        String endpointWithLeadingSlash = !endpoint.startsWith("/") ? new StringBuilder(1).append("/").append(endpoint).toString() : endpoint;
        return this.withStateChangeUrl(new StringBuilder(4).append(this.protocol).append("://").append(this.host).append(":").append(this.port).append(endpointWithLeadingSlash).toString());
    }

    public ProviderInfoBuilder withStateChangeFunctionAndResponse(PartialFunction<ProviderState, Map<String, String>> stateChange) {
        return this.withStateManagementFunction(StateManagement$StateManagementFunction$.MODULE$.withResponse(stateChange));
    }

    public ProviderInfoBuilder withStateChangeFunction(PartialFunction<ProviderState, BoxedUnit> stateChange) {
        return this.withStateManagementFunction(StateManagement$StateManagementFunction$.MODULE$.apply(stateChange));
    }

    public ProviderInfoBuilder withStateChangeFunction(Function1<ProviderState, BoxedUnit> stateChange) {
        return this.withStateChangeFunction((PartialFunction<ProviderState, BoxedUnit>)new Serializable(stateChange){
            private final Function1 stateChange$1;
            {
                this.stateChange$1 = stateChange$2;
            }

            public final boolean isDefinedAt(ProviderState x) {
                ProviderState providerState;
                ProviderState x2 = providerState = x;
                return true;
            }

            public final Object applyOrElse(ProviderState x, Function1 function1) {
                ProviderState providerState;
                ProviderState x2 = providerState = x;
                this.stateChange$1.apply((Object)x2);
                return BoxedUnit.UNIT;
            }
        });
    }

    public ProviderInfoBuilder withStateManagementFunction(StateManagement.StateManagementFunction stateManagementFunction) {
        Some some = Some$.MODULE$.apply((Object)stateManagementFunction);
        String string = this.copy$default$1();
        String string2 = this.copy$default$2();
        String string3 = this.copy$default$3();
        int n = this.copy$default$4();
        String string4 = this.copy$default$5();
        PactSource pactSource = this.copy$default$6();
        Option<VerificationSettings> option = this.copy$default$8();
        Function1<ProviderRequest, Option<ProviderRequestFilter>> function1 = this.copy$default$9();
        return this.copy(string, string2, string3, n, string4, pactSource, (Option<StateManagement>)some, option, function1);
    }

    public ProviderInfoBuilder withStateChangeFunctionConfigOverrides(Function1<StateManagement.StateManagementFunction, StateManagement.StateManagementFunction> overrides) {
        Option withOverrides = this.stateManagement.map((Function1 & Serializable)x$1 -> {
            StateManagement stateManagement = x$1;
            if (stateManagement instanceof StateManagement.ProviderUrl) {
                StateManagement.ProviderUrl x = (StateManagement.ProviderUrl)stateManagement;
                return x;
            }
            if (stateManagement instanceof StateManagement.StateManagementFunction) {
                StateManagement.StateManagementFunction x = (StateManagement.StateManagementFunction)stateManagement;
                return (StateManagement)overrides.apply((Object)x);
            }
            throw new MatchError((Object)stateManagement);
        });
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), (Option<StateManagement>)withOverrides, this.copy$default$8(), this.copy$default$9());
    }

    public ProviderInfoBuilder withRequestFilter(Function1<ProviderRequest, List<ProviderRequestFilter>> requestFilter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), (Function1<ProviderRequest, Option<ProviderRequestFilter>>)(Function1 & Serializable)request -> ((IterableOnceOps)requestFilter.apply(request)).reduceLeftOption((Function2 & Serializable)(_$1, _$2) -> _$1.andThen((ProviderRequestFilter)_$2)));
    }

    public ProviderInfoBuilder withRequestFiltering(Function1<ProviderRequest, ProviderRequestFilter> requestFilter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), (Function1<ProviderRequest, Option<ProviderRequestFilter>>)(Function1 & Serializable)request -> Some$.MODULE$.apply(requestFilter.apply(request)));
    }

    public Function1<HttpRequest, BoxedUnit> pact4s$provider$ProviderInfoBuilder$$pactJvmRequestFilter() {
        return (JProcedure1 & Serializable)request -> {
            ProviderRequest providerRequest = ProviderRequest$.MODULE$.apply(request.getMethod(), request.getUri(), (List<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])request.getHeaders()).toList().map((Function1 & Serializable)h -> Tuple2$.MODULE$.apply((Object)h.getName(), (Object)h.getValue())));
            ((Option)this.requestFilter.apply((Object)providerRequest)).foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.filterImpl((HttpRequest)request));
        };
    }

    public Either<Throwable, ProviderInfo> build(Option<Branch> providerBranch, Option<Function1<String, ResponseBuilder>> responseFactory, Option<String> stateChangeUrl) {
        ProviderInfo p = new ProviderInfo(this.name, this.protocol, (Object)this.host, (Object)BoxesRunTime.boxToInteger((int)this.port), this.path);
        responseFactory.foreach((Function1)(JProcedure1 & Serializable)_$4 -> p.setVerificationType(PactVerification.RESPONSE_FACTORY));
        this.verificationSettings.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            VerificationSettings verificationSettings = x$1;
            if (verificationSettings instanceof VerificationSettings.AnnotatedMethodVerificationSettings) {
                List<String> list;
                VerificationSettings.AnnotatedMethodVerificationSettings annotatedMethodVerificationSettings = VerificationSettings$AnnotatedMethodVerificationSettings$.MODULE$.unapply((VerificationSettings.AnnotatedMethodVerificationSettings)verificationSettings);
                List<String> packagesToScan = list = annotatedMethodVerificationSettings._1();
                p.setVerificationType(PactVerification.ANNOTATED_METHOD);
                p.setPackagesToScan(CollectionConverters$.MODULE$.SeqHasAsJava(packagesToScan).asJava());
                return;
            }
            throw new MatchError((Object)verificationSettings);
        });
        stateChangeUrl.foreach((Function1)(JProcedure1 & Serializable)s -> p.setStateChangeUrl(new URI((String)s).toURL()));
        p.setRequestFilter((Object)new Consumer<HttpRequest>(this){
            private final /* synthetic */ ProviderInfoBuilder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void accept(HttpRequest t) {
                this.$outer.pact4s$provider$ProviderInfoBuilder$$pactJvmRequestFilter().apply((Object)t);
            }
        });
        PactSource pactSource = this.pactSource;
        if (pactSource instanceof PactSource.PactBroker) {
            PactSource.PactBroker broker = (PactSource.PactBroker)pactSource;
            return this.applyBrokerSourceToProvider(p, broker, providerBranch);
        }
        if (pactSource instanceof PactSource.FileSource) {
            PactSource.FileSource f = (PactSource.FileSource)pactSource;
            f.consumers().foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String consumer2 = (String)tuple2._1();
                    File file = (File)tuple2._2();
                    return p.hasPactWith(consumer2, consumer -> {
                        consumer.setPactSource((Object)new FileSource(file));
                        return Unit.INSTANCE;
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            return package$.MODULE$.Right().apply((Object)p);
        }
        throw new MatchError((Object)pactSource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Throwable, ProviderInfo> applyBrokerSourceToProvider(ProviderInfo providerInfo, PactSource.PactBroker pactSource, Option<Branch> providerBranch) {
        while (true) {
            PactSource.PactBroker pactBroker;
            if ((pactBroker = pactSource) instanceof PactSource.PactBrokerWithSelectors) {
                Auth.None none;
                PactSource.PactBrokerWithSelectors p = (PactSource.PactBrokerWithSelectors)pactBroker;
                Either<Throwable, BoxedUnit> either = p.validate(providerBranch);
                if (either instanceof Left) {
                    Throwable value = (Throwable)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)value);
                }
                if (!(either instanceof Right)) throw new MatchError(either);
                Option<Authentication> option = p.auth();
                if (None$.MODULE$.equals(option)) {
                    none = Auth.None.INSTANCE;
                } else {
                    if (!(option instanceof Some)) throw new MatchError(option);
                    Authentication authentication = (Authentication)((Some)option).value();
                    if (authentication instanceof Authentication.TokenAuth) {
                        String string;
                        Authentication.TokenAuth tokenAuth = Authentication$TokenAuth$.MODULE$.unapply((Authentication.TokenAuth)authentication);
                        String token = string = tokenAuth._1();
                        none = new Auth.BearerAuthentication(token, "Authorization");
                    } else {
                        if (!(authentication instanceof Authentication.BasicAuth)) throw new MatchError(option);
                        Authentication.BasicAuth basicAuth = Authentication$BasicAuth$.MODULE$.unapply((Authentication.BasicAuth)authentication);
                        String string = basicAuth._1();
                        String string2 = basicAuth._2();
                        String user = string;
                        String pass = string2;
                        none = new Auth.BasicAuthentication(user, pass);
                    }
                }
                Auth.None pactJvmAuth = none;
                PactBrokerOptions brokerOptions = new PactBrokerOptions(p.enablePending(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)p.providerTags().map((Function1 & Serializable)_$5 -> _$5.toList()).getOrElse(ProviderInfoBuilder::$anonfun$4)).asJava(), (String)providerBranch.map((Function1 & Serializable)_$6 -> _$6.branch()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)p.includeWipPactsSince().since().map((Function1 & Serializable)instant -> this.instantToDateString((Instant)instant)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), p.insecureTLS(), (Auth)pactJvmAuth);
                Try applySelectors = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    ProviderInfoBuilder.$anonfun$7(providerInfo, p, brokerOptions);
                    return BoxedUnit.UNIT;
                });
                return applySelectors.toEither().map((Function1 & Serializable)_$7 -> providerInfo);
            }
            if (!(pactBroker instanceof PactSource.PactBrokerWithTags)) throw new MatchError((Object)pactBroker);
            PactSource.PactBrokerWithTags p = (PactSource.PactBrokerWithTags)pactBroker;
            pactSource = p.toPactBrokerWithSelectors();
        }
    }

    private String instantToDateString(Instant instant) {
        return instant.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private static final List $anonfun$4() {
        return package$.MODULE$.Nil();
    }

    private static final void $anonfun$7(ProviderInfo providerInfo$1, PactSource.PactBrokerWithSelectors p$5, PactBrokerOptions brokerOptions$1) {
        providerInfo$1.hasPactsFromPactBrokerWithSelectorsV2(p$5.brokerUrl(), p$5.consumerVersionSelectors().asJava(), brokerOptions$1);
    }
}

