/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.conventions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public class ExtractResources
extends DefaultTask {
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private final Map<String, String> properties = new HashMap<String, String>();
    private final DirectoryProperty destinationDirectory;
    private List<String> resourceNames = new ArrayList<String>();

    public ExtractResources() {
        this.destinationDirectory = this.getProject().getObjects().directoryProperty();
    }

    @Input
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourcesNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void property(String name, String value) {
        this.properties.put(name, value);
    }

    @Input
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @TaskAction
    void extractResources() throws IOException {
        for (String resourceName : this.resourceNames) {
            InputStream resourceStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
            if (resourceStream == null) {
                throw new GradleException("Resource '" + resourceName + "' does not exist");
            }
            String resource = FileCopyUtils.copyToString((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
            resource = this.propertyPlaceholderHelper.replacePlaceholders(resource, this.properties::get);
            FileCopyUtils.copy((String)resource, (Writer)new FileWriter(((RegularFile)this.destinationDirectory.file(resourceName).get()).getAsFile()));
        }
    }
}

