/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.conventions;

import io.github.jcohy.gradle.version.ReleaseStatus;
import io.github.jcohy.gradle.version.Repository;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomOrganization;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.SourceSet;
import org.springframework.util.StringUtils;

class MavenPublishingConventions {
    MavenPublishingConventions() {
    }

    void apply(Project project) {
        project.getPlugins().withType(MavenPublishPlugin.class).all(mavenPublishPlugin -> {
            PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            publishing.getRepositories().maven(mavenRepository -> {
                Repository repository = Repository.of(ReleaseStatus.ofProject(project));
                mavenRepository.setUrl((Object)repository.getUrl());
                mavenRepository.setName(repository.getName());
                mavenRepository.credentials(passwordCredentials -> {
                    String username = StringUtils.hasText((String)this.getExtraProperties(project, "USERNAME")) ? this.getExtraProperties(project, "username") : "xw-developer";
                    String password = StringUtils.hasText((String)this.getExtraProperties(project, "PASSWORD")) ? this.getExtraProperties(project, "password") : "developer";
                    passwordCredentials.setUsername(username);
                    passwordCredentials.setPassword(password);
                });
            });
            publishing.getPublications().withType(MavenPublication.class).all(mavenPublication -> this.customizeMavenPublication((MavenPublication)mavenPublication, project));
            project.getPlugins().withType(JavaPlugin.class).all(javaPlugin -> {
                JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
                extension.withJavadocJar();
                extension.withSourcesJar();
            });
        });
    }

    public String getExtraProperties(Project project, String property) {
        ExtraPropertiesExtension extra = project.getExtensions().getExtraProperties();
        return extra.has(property) ? (String)extra.get(property) : "";
    }

    private void customizeMavenPublication(MavenPublication publication, Project project) {
        this.customizePom(publication.getPom(), project);
        project.getPlugins().withType(JavaPlugin.class).all(javaPlugin -> this.customizeJavaMavenPublication(publication, project));
        this.suppressMavenOptionalFeatureWarnings(publication);
    }

    private void suppressMavenOptionalFeatureWarnings(MavenPublication publication) {
        publication.suppressPomMetadataWarningsFor("mavenOptionalApiElements");
        publication.suppressPomMetadataWarningsFor("mavenOptionalRuntimeElements");
    }

    private void customizeJavaMavenPublication(MavenPublication publication, Project project) {
        this.addMavenOptionalFeature(project);
        publication.versionMapping(strategy -> strategy.usage("java-api", mappingStrategy -> mappingStrategy.fromResolutionOf("runtimeClasspath")));
        publication.versionMapping(strategy -> strategy.usage("java-runtime", mappingStrategy -> mappingStrategy.fromResolutionResult()));
    }

    private void addMavenOptionalFeature(Project project) {
        JavaPluginExtension extension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        extension.registerFeature("mavenOptional", feature -> feature.usingSourceSet((SourceSet)convention.getSourceSets().getByName("main")));
        AdhocComponentWithVariants javaComponent = (AdhocComponentWithVariants)project.getComponents().findByName("java");
        javaComponent.addVariantsFromConfiguration((Configuration)project.getConfigurations().findByName("mavenOptionalRuntimeElements"), ConfigurationVariantDetails::mapToOptional);
    }

    private void customizePom(MavenPom pom, Project project) {
        pom.getUrl().set((Object)"https://github.com/jcohy/jcohy-gradle-plugins.git");
        pom.getName().set(project.provider(() -> ((Project)project).getName()));
        pom.getDescription().set(project.provider(() -> ((Project)project).getDescription()));
        if (!this.isUserInherited(project)) {
            pom.organization(this::customizeOrganization);
        }
        pom.licenses(this::customizeLicenses);
        pom.developers(this::customizeDevelopers);
        pom.scm(scm -> this.customizeScm((MavenPomScm)scm, project));
        if (!this.isUserInherited(project)) {
            pom.issueManagement(this::customizeIssueManagement);
        }
    }

    private void customizeIssueManagement(MavenPomIssueManagement issueManagement) {
        issueManagement.getSystem().set((Object)"GitHub");
        issueManagement.getUrl().set((Object)"https://github.com/jcohy/jcohy-gradle-plugins/issues");
    }

    private void customizeScm(MavenPomScm scm, Project project) {
        if (!this.isUserInherited(project)) {
            scm.getConnection().set((Object)"scm:git:git://github.com/jcohy/jcohy-gradle-plugins");
            scm.getDeveloperConnection().set((Object)"scm:git:git://github.com/jcohy/jiachao23");
        }
        scm.getUrl().set((Object)"https://github.com/jcohy/jcohy-gradle-plugins.git");
    }

    private void customizeDevelopers(MavenPomDeveloperSpec developers) {
        developers.developer(developer -> {
            developer.getName().set((Object)"jiachao23");
            developer.getEmail().set((Object)"jia_chao23@126.com");
            developer.getOrganization().set((Object)"jcohy");
            developer.getOrganizationUrl().set((Object)"https://github.com/jcohy");
        });
    }

    private void customizeLicenses(MavenPomLicenseSpec licenses) {
        licenses.license(licence -> {
            licence.getName().set((Object)"Apache License, Version 2.0");
            licence.getUrl().set((Object)"https://www.apache.org/licenses/LICENSE-2.0");
        });
    }

    private void customizeOrganization(MavenPomOrganization organization) {
        organization.getName().set((Object)"jcohy");
        organization.getUrl().set((Object)"https://github.com/jcohy");
    }

    private boolean isUserInherited(Project project) {
        return "flight-framework-bom".equals(project.getName());
    }
}

