/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.testing;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;

public abstract class TestResultsOverview
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener,
AutoCloseable {
    private final Map<Test, List<TestFailure>> testFailures = new TreeMap<Test, List<TestFailure>>(Comparator.comparing(DefaultTask::getPath));
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailures(Test test, List<TestDescriptor> failureDescriptors) {
        List testFailures = failureDescriptors.stream().map(TestFailure::new).sorted().collect(Collectors.toList());
        Object object = this.monitor;
        synchronized (object) {
            this.testFailures.put(test, testFailures);
        }
    }

    public void onFinish(FinishEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.testFailures.isEmpty()) {
                return;
            }
            System.err.println();
            System.err.println("Found test failures in " + this.testFailures.size() + " test task" + (this.testFailures.size() == 1 ? ":" : "s:"));
            this.testFailures.forEach((task, failures) -> {
                System.err.println();
                System.err.println(task.getPath());
                failures.forEach(failure -> System.err.println("    " + failure.descriptor.getClassName() + " > " + failure.descriptor.getName()));
            });
        }
    }

    private record TestFailure(TestDescriptor descriptor) implements Comparable<TestFailure>
    {
        @Override
        public int compareTo(TestFailure other) {
            int comparison = this.descriptor.getClassName().compareTo(other.descriptor.getClassName());
            if (comparison == 0) {
                comparison = this.descriptor.getName().compareTo(other.descriptor.getName());
            }
            return comparison;
        }
    }
}

