/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.toolchain;

import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class ToolchainExtension {
    private final Property<JavaLanguageVersion> maximumCompatibleJavaVersion;
    private final JavaLanguageVersion javaVersion;

    public ToolchainExtension(Project project) {
        this.maximumCompatibleJavaVersion = project.getObjects().property(JavaLanguageVersion.class);
        String toolchainVersion = (String)project.findProperty("toolchainVersion");
        this.javaVersion = toolchainVersion != null ? JavaLanguageVersion.of((String)toolchainVersion) : null;
    }

    public Property<JavaLanguageVersion> getMaximumCompatibleJavaVersion() {
        return this.maximumCompatibleJavaVersion;
    }

    JavaLanguageVersion getJavaVersion() {
        return this.javaVersion;
    }
}

