/*
 * Decompiled with CFR 0.152.
 */
package io.github.jcohy.gradle.toolchain;

import io.github.jcohy.gradle.toolchain.ToolchainExtension;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.GradleBuild;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class ToolchainPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        this.configureToolchain(project);
    }

    private void configureToolchain(Project project) {
        ToolchainExtension toolchain = (ToolchainExtension)project.getExtensions().create("toolchain", ToolchainExtension.class, new Object[]{project});
        JavaLanguageVersion toolchainVersion = toolchain.getJavaVersion();
        if (toolchainVersion != null) {
            project.afterEvaluate(evaluated -> this.configure((Project)evaluated, toolchain));
        }
    }

    private void configure(Project project, ToolchainExtension toolchain) {
        if (!this.isJavaVersionSupported(toolchain, toolchain.getJavaVersion())) {
            this.disableToolchainTasks(project);
        } else {
            JavaToolchainSpec toolchainSpec = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
            toolchainSpec.getLanguageVersion().set((Object)toolchain.getJavaVersion());
            this.configureJavaCompileToolchain(project, toolchain);
            this.configureTestToolchain(project, toolchain);
        }
    }

    private boolean isJavaVersionSupported(ToolchainExtension toolchain, JavaLanguageVersion toolchainVersion) {
        return (Boolean)toolchain.getMaximumCompatibleJavaVersion().map(version -> version.canCompileOrRun(toolchainVersion)).getOrElse((Object)true);
    }

    private void disableToolchainTasks(Project project) {
        project.getTasks().withType(JavaCompile.class, task -> task.setEnabled(false));
        project.getTasks().withType(Javadoc.class, task -> task.setEnabled(false));
        project.getTasks().withType(Test.class, task -> task.setEnabled(false));
        project.getTasks().withType(GradleBuild.class, task -> task.setEnabled(false));
    }

    private void configureJavaCompileToolchain(Project project, ToolchainExtension toolchain) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            compile.getOptions().setFork(true);
            List<String> forkArgs = Arrays.asList("--add-opens", "jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED");
            compile.getOptions().getForkOptions().getJvmArgs().addAll(forkArgs);
        });
    }

    private void configureTestToolchain(Project project, ToolchainExtension toolchain) {
        project.getTasks().withType(Test.class, test -> {
            List<String> arguments = Arrays.asList("--add-exports=java.naming/com.sun.jndi.ldap=ALL-UNNAMED", "--illegal-access=warn");
            test.jvmArgs(arguments);
        });
    }
}

